/*!
 * @file        sc_math.h
 *
 * @brief
 *
 * @version     V1.0.3
 *
 * @date        2025-06-17
 *
 * @attention
 *
 *  Copyright (C) 2022-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef __SC_MATH_H__
#define __SC_MATH_H__

/** @addtogroup Examples
  @{
  */

/** @addtogroup FPU_Math
  @{
  */

/** @defgroup FPU_Math_SC_Functions SC_Functions
  @{
  */

extern float sc_math_sin(float x);
extern float sc_math_cos(float x);
extern float sc_math_tan(float x);
extern float sc_math_asin(float x);
extern float sc_math_acos(float x);
extern float sc_math_atan(float x);
extern float sc_math_atan2(float y, float x);

extern float sc_math_invsqrt(float x);
extern float sc_math_mac(float x, float y, float z);
extern float sc_math_sum_N(float* x, unsigned char n);
extern float sc_math_sub_N(float* x, unsigned char n);
extern float sc_math_prdct(float* x, unsigned char n);
extern float sc_math_sumsq(float* x, unsigned char n);

/**@} end of group FPU_Math_SC_Functions */
/**@} end of group FPU_Math */
/**@} end of group Examples */

#endif
