/*!
 * @file        Board.c
 *
 * @brief       This file provides firmware functions to manage Leds and push-buttons
 *
 * @version     V1.0.3
 *
 * @date        2025-07-07
 *
 * @attention
 *
 *  Copyright (C) 2020-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes */
#include "Board.h"

#ifdef BOARD_APM32F030_MINI
    #include "Board_APM32F030_MINI/src/Board_APM32F030_MINI.c"
#endif

#ifdef BOARD_APM32F051_MINI
    #include "Board_APM32F051_MINI/src/Board_APM32F051_MINI.c"
#endif

#ifdef BOARD_APM32F072_MINI
    #include "Board_APM32F072_MINI/src/Board_APM32F072_MINI.c"
#endif

#ifdef BOARD_APM32F091_MINI
    #include "Board_APM32F091_MINI/src/Board_APM32F091_MINI.c"
#endif

