/*!
 * @file        usbd_board.h
 *
 * @brief       Header file for USB Board
 *
 * @version     V1.0.0
 *
 * @date        2024-12-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef USBD_BOARD_H
#define USBD_BOARD_H

/* Includes ***************************************************************/
#include "apm32f402_403.h"
#include "apm32f402_403_usb.h"
#include "apm32f402_403_usb_device.h"
#include "board_delay.h"

/* Exported macro *********************************************************/

#define USBH_CHANNEL_MAX_NUM                0x10    /*!<  Host channel number*/
#define USBH_DATA_BUF_MAX_NUM               0x200
#define INTERFACE_DESC_MAX_NUM              2
#define ENDPOINT_DESC_MAX_NUM               2
#define USBH_SUP_CLASS_MAX_NUM              1

#define USBH_DEBUG_LEVEL                    2U

#if (USBH_DEBUG_LEVEL > 0U)
#define USBH_USR_LOG(...)   do { \
                            printf("INFO :"); \
                            printf(__VA_ARGS__); \
                            printf("\r\n"); \
} while(0)
#else
#define USBH_USR_LOG(...) do {} while (0)
#endif

#if (USBH_DEBUG_LEVEL > 1U)
#define USBH_USR_DBG(...)   do { \
                            printf("DEBUG:"); \
                            printf(__VA_ARGS__); \
                            printf("\r\n"); \
} while(0)
#else
#define USBH_USR_DBG(...)   do {} while (0)
#endif

#if (USBH_DEBUG_LEVEL > 2U)
#define USBH_USR_ERR(...)   do { \
                            printf("ERROR:"); \
                            printf(__VA_ARGS__); \
                            printf("\r\n"); \
} while(0)
#else
#define USBH_USR_ERR(...)   do {} while (0)
#endif

/* Exported typedef *******************************************************/

/* Exported function prototypes *******************************************/

#endif /* USBD_BOARD_H */
