/**
 * @file        apm32f4xx_gpio_cfg.c
 *
 * @brief       This file provides configuration support for GPIO
 *
 * @version     V1.0.0
 *
 * @date        2024-08-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_gpio_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   GPIO configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DDL_GPIO_Config(void)
{
    DDL_GPIO_InitTypeDef GPIO_InitStruct = {0U};

    /* Configure the LED pin */
    GPIO_InitStruct.Pin         = DDL_GPIO_PIN_5;
    GPIO_InitStruct.Mode        = DDL_GPIO_MODE_OUTPUT;
    GPIO_InitStruct.Speed       = DDL_GPIO_SPEED_FREQ_LOW;
    GPIO_InitStruct.OutputType  = DDL_GPIO_OUTPUT_PUSHPULL;
    DDL_GPIO_Init(GPIOC, &GPIO_InitStruct);
}
