/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2024-08-01
 *
 * @attention
 *
 *  Copyright (C) 2024-2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

static const uint32_t dataBuffer[114] =
{
    0x00001021U, 0x20423063U, 0x408450a5U, 0x60c670e7U, 0x9129a14aU, 0xb16bc18cU,
    0xd1ade1ceU, 0xf1ef1231U, 0x32732252U, 0x52b54294U, 0x72f762d6U, 0x93398318U,
    0xa35ad3bdU, 0xc39cf3ffU, 0xe3de2462U, 0x34430420U, 0x64e674c7U, 0x44a45485U,
    0xa56ab54bU, 0x85289509U, 0xf5cfc5acU, 0xd58d3653U, 0x26721611U, 0x063076d7U,
    0x569546b4U, 0xb75ba77aU, 0x97198738U, 0xf7dfe7feU, 0xc7bc48c4U, 0x58e56886U,
    0x78a70840U, 0x18612802U, 0xc9ccd9edU, 0xe98ef9afU, 0x89489969U, 0xa90ab92bU,
    0x4ad47ab7U, 0x6a961a71U, 0x0a503a33U, 0x2a12dbfdU, 0xfbbfeb9eU, 0x9b798b58U,
    0xbb3bab1aU, 0x6ca67c87U, 0x5cc52c22U, 0x3c030c60U, 0x1c41edaeU, 0xfd8fcdecU,
    0xad2abd0bU, 0x8d689d49U, 0x7e976eb6U, 0x5ed54ef4U, 0x2e321e51U, 0x0e70ff9fU,
    0xefbedfddU, 0xcffcbf1bU, 0x9f598f78U, 0x918881a9U, 0xb1caa1ebU, 0xd10cc12dU,
    0xe16f1080U, 0x00a130c2U, 0x20e35004U, 0x40257046U, 0x83b99398U, 0xa3fbb3daU,
    0xc33dd31cU, 0xe37ff35eU, 0x129022f3U, 0x32d24235U, 0x52146277U, 0x7256b5eaU,
    0x95a88589U, 0xf56ee54fU, 0xd52cc50dU, 0x34e224c3U, 0x04817466U, 0x64475424U,
    0x4405a7dbU, 0xb7fa8799U, 0xe75ff77eU, 0xc71dd73cU, 0x26d336f2U, 0x069116b0U,
    0x76764615U, 0x5634d94cU, 0xc96df90eU, 0xe92f99c8U, 0xb98aa9abU, 0x58444865U,
    0x78066827U, 0x18c008e1U, 0x28a3cb7dU, 0xdb5ceb3fU, 0xfb1e8bf9U, 0x9bd8abbbU,
    0x4a755a54U, 0x6a377a16U, 0x0af11ad0U, 0x2ab33a92U, 0xed0fdd6cU, 0xcd4dbdaaU,
    0xad8b9de8U, 0x8dc97c26U, 0x5c644c45U, 0x3ca22c83U, 0x1ce00cc1U, 0xef1fff3eU,
    0xdf7caf9bU, 0xbfba8fd9U, 0x9ff86e17U, 0x7e364e55U, 0x2e933eb2U, 0x0ed11ef0U
};

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern CRC_HandleTypeDef hcrc;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    uint32_t crcValue = 0U;
    
    /* Device configuration */
    DAL_DeviceConfig();

    /* Infinite loop */
    while (1)
    {
        /* Compute the CRC of "dataBuffer" */
        crcValue = DAL_CRC_Calculate(&hcrc, (uint32_t *)dataBuffer, 114U);
        LOGI(tag, "Calculate block CRC = 0x%08X\r\n", crcValue);
        BOARD_LED_Toggle(LED2);
        DAL_Delay(500U);
    }
}
