/**
 * @file        cameraif.h
 *
 * @brief       This file provides configuration support for camera
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef CAMERAIF_H
#define CAMERAIF_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes ***************************************************************/
#include "apm32f4xx_dal.h"

/* Exported macro *********************************************************/
/**
 * @brief Camera SCCB address
 */
#define CAMERA_SCCB_ADDRESS             0x60U

/**
 * @brief OV2640 MID default value
 */
#define OV2640_MID                      0x7FA2U
/**
 * @brief OV2640 PID default value
 */
#define OV2640_PID                      0x2642U

/**
 * @brief Camera hardware reset
 */
#define CAMERA_HARDWARE_RESET

#if defined(CAMERA_HARDWARE_RESET)
#define CAMERA_RESET_GPIO_PORT          GPIOF
#define CAMERA_RESET_GPIO_PIN           GPIO_PIN_13
#endif /* CAMERA_HARDWARE_RESET */

/**
 * @brief Camera power down
 */
#define CAMERA_POWER_DOWN

#if defined(CAMERA_POWER_DOWN)
#define CAMERA_PWDN_GPIO_PORT           GPIOA
#define CAMERA_PWDN_GPIO_PIN            GPIO_PIN_0
#endif /* CAMERA_POWER_DOWN */

/**
 * @brief Camera_Status Camera status
 */
#define CAMERA_STATUS_OK                0x00U
#define CAMERA_STATUS_ERROR             0x01U
#define CAMERA_STATUS_TIMEOUT           0x02U

/**
 * @brief Camera_Image_Format Camera image format
 */
#define CAMERA_IMG_J160x120             0x00U
#define CAMERA_IMG_J320x240             0x01U

/* Exported typedef *******************************************************/

/**
 * @brief Camera_Information Camera information
 */
typedef struct
{
    uint32_t format;
    uint32_t size;
} CAMERA_INFO_T;

/* Exported function prototypes *******************************************/
uint32_t CAMERA_Config(uint32_t format);

#ifdef __cplusplus
}
#endif

#endif /* CAMERAIF_H */
