/**
 * @file        lcd_font.h
 *
 * @brief       This file provides application support for LCD Font
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef LCD_FONT_H
#define LCD_FONT_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes ***************************************************************/
#include "apm32f4xx_dal.h"

/* Exported macro *********************************************************/

/* Exported typedef *******************************************************/

/**
 * @brief  Font structure used on LCD
 */
typedef struct
{
    uint16_t width;
    uint16_t height;
    uint8_t *pTable;
} LCD_FONT_T;

/* Exported function prototypes *******************************************/

#ifdef __cplusplus
}
#endif

#endif /* LCD_FONT_H */
