/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

__IO uint16_t adc1ConvValue = 0U;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern ADC_HandleTypeDef hadc1;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Strat ADC conversation */
    if (DAL_ADC_Start_IT(&hadc1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
    }
}

/**
 * @brief  Regular conversion complete callback in non blocking mode
 *
 * @param  hadc pointer to a ADC_HandleTypeDef structure that contains
 *         the configuration information for the specified ADC
 *
 * @retval None
 */
void DAL_ADC_ConvCpltCallback(ADC_HandleTypeDef* hadc)
{
    uint16_t voltage;
    
    /* Get the converted value */
    adc1ConvValue = DAL_ADC_GetValue(hadc);

    voltage = (adc1ConvValue * 3300U) / 4095U;

    LOGI(tag, "ADC1 CH0 Value: %d mV\r\n",voltage);

    /* Strat ADC Conversation */
    if (DAL_ADC_Start_IT(&hadc1) != DAL_OK)
    {
        Error_Handler();
    }
}
