/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";
__IO uint8_t lowPowerMode = 0U;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Infinite loop */
    while (1)
    {
        if (lowPowerMode == 1U)
        {
            BOARD_LED_Off(LED2);
            BOARD_LED_Off(LED3);
            
            /* Suspend system tick */
            DAL_SuspendTick();

            LOGI(tag, "Enter sleep mode\r\n");

            /* Wait for interrupt */
            DAL_PMU_EnterSLEEPMode(PMU_MAINREGULATOR_ON, PMU_SLEEPENTRY_WFI);

            /* Resume system tick */
            DAL_ResumeTick();
            LOGI(tag, "Exit sleep mode\r\n");
            lowPowerMode = 0U;
        }
        else
        {
            BOARD_LED_Toggle(LED2);
            DAL_Delay(500U);
            LOGI(tag, "Running...\r\n");
        }
    }
}

/**
 * @brief  EINT line detection callbacks
 *
 * @param  GPIO_Pin Specifies the pins connected EINT line
 *
 * @retval None
 */
void DAL_GPIO_EINT_Callback(uint16_t GPIO_Pin)
{
    if (GPIO_Pin == GPIO_PIN_0)
    {
        BOARD_LED_Toggle(LED2);
        lowPowerMode = 1U;
    }

    if (GPIO_Pin == GPIO_PIN_1)
    {
        BOARD_LED_Toggle(LED3);
        lowPowerMode = 1U;
    }
}
