/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-07-31
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern TMR_HandleTypeDef htmr3;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Generate raising edge */
    DAL_GPIO_WritePin(GPIOA, GPIO_PIN_1, GPIO_PIN_SET);
    DAL_GPIO_WritePin(GPIOA, GPIO_PIN_2, GPIO_PIN_SET);
    DAL_GPIO_WritePin(GPIOA, GPIO_PIN_3, GPIO_PIN_SET);
    DAL_GPIO_WritePin(GPIOA, GPIO_PIN_4, GPIO_PIN_SET);

    /* Start TMR3 channel 1 */
    if (DAL_TMR_OC_Start_IT(&htmr3, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }
    
    /* Start TMR3 channel 2 */
    if (DAL_TMR_OC_Start_IT(&htmr3, TMR_CHANNEL_2) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start TMR3 channel 3 */
    if (DAL_TMR_OC_Start_IT(&htmr3, TMR_CHANNEL_3) != DAL_OK)
    {
        Error_Handler();
    }

    /* Start TMR3 channel 4 */
    if (DAL_TMR_OC_Start_IT(&htmr3, TMR_CHANNEL_4) != DAL_OK)
    {
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
        
    }
}

/**
 * @brief  Output Compare callback in non-blocking mode
 *
 * @param  htmr TMR OC handle
 *
 * @retval None
 */
void DAL_TMR_OC_DelayElapsedCallback(TMR_HandleTypeDef *htmr)
{
    if (htmr->Channel == DAL_TMR_ACTIVE_CHANNEL_1)
    {
        DAL_GPIO_WritePin(GPIOA, GPIO_PIN_1, GPIO_PIN_RESET);
    }
    else if (htmr->Channel == DAL_TMR_ACTIVE_CHANNEL_2)
    {
        DAL_GPIO_WritePin(GPIOA, GPIO_PIN_2, GPIO_PIN_RESET);
    }
    else if (htmr->Channel == DAL_TMR_ACTIVE_CHANNEL_3)
    {
        DAL_GPIO_WritePin(GPIOA, GPIO_PIN_3, GPIO_PIN_RESET);
    }
    else
    {
        DAL_GPIO_WritePin(GPIOA, GPIO_PIN_4, GPIO_PIN_RESET);
    }
}
