/* ----------------------------------------------------------------------
* Copyright (C) 2010-2020 ARM Limited. All rights reserved.
*
* $Date:         23. March 2020
* $Revision:     V1.7.0
*
* Project:       CMSIS DSP Library
* Title:         arm_linear_interp_data.c
*
* Description:   Data file used for example.  Generation method described
*                below
*
* Target Processor: Cortex-M55/Cortex-M7/Cortex-M4/Cortex-M3/Cortex-M0
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*   - Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*   - Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in
*     the documentation and/or other materials provided with the
*     distribution.
*   - Neither the name of ARM LIMITED nor the names of its contributors
*     may be used to endorse or promote products derived from this
*     software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
* COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
* ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
 * -------------------------------------------------------------------- */

/* ----------------------------------------------------------------------
* Table generated from following MATLAB Command
* x = -pi: 0.005 : (2*pi - 0.005);
* y = sin(x);
* where pi value is 3.141592653589793
* --------------------------------------------------------------------*/

const float arm_linear_interep_table[1884] =  {
  -0.00000000000000012246,  -0.00499997916669272461,  -0.00999983333416657426,  -0.01499943750632833778,  -0.01999866669333321897,  -0.02499739591471236352,  -0.02999550020249558760,  -0.03499285460433645967,
  -0.03998933418663432049,  -0.04498481403766028952,  -0.04997916927067827531,  -0.05497227502706801550,  -0.05996400647944477580,  -0.06495423883478267102,  -0.06994284733753272643,  -0.07492970727274264608,
  -0.07991469396917287582,  -0.08489768280241610787,  -0.08987854919801102627,  -0.09485716863455760650,  -0.09983341664682836292,  -0.10480716882888259367,  -0.10977830083717481091,  -0.11474668839366414241,
  -0.11971220728891958374,  -0.12467473338522781778,  -0.12963414261969488650,  -0.13459031100734822339,  -0.13954311464423671540,  -0.14449242971052655982,  -0.14943813247359924445,  -0.15438009929114335228,
  -0.15931820661424622720,  -0.16425233099048111574,  -0.16918234906699605724,  -0.17410813759359589081,  -0.17902957342582445643,  -0.18394653352804138380,  -0.18885889497650065749,  -0.19376653496242188246,
  -0.19866933079506152171,  -0.20356715990477816658,  -0.20845989984609966661,  -0.21334742830078226583,  -0.21822962308086962802,  -0.22310636213174564468,  -0.22797752353518849211,  -0.23284298551241677799,
  -0.23770262642713491097,  -0.24255632478857228063,  -0.24740395925452304815,  -0.25224540863437805438,  -0.25708055189215500702,  -0.26190926814952469881,  -0.26673143668883125823,  -0.27154693695611287207,
  -0.27635564856411409806,  -0.28115745129529429169,  -0.28595222510483570000,  -0.29073985012364278457,  -0.29552020666133954618,  -0.30029317520926179785,  -0.30505863644344366481,  -0.30981647122760291868,
  -0.31456656061611770747,  -0.31930878585700123162,  -0.32404302839486853749,  -0.32876916987390319980,  -0.33348709214081440066,  -0.33819667724779156615,  -0.34289780745545156426,  -0.34759036523578440425,
  -0.35227423327508999851,  -0.35694929447691170488,  -0.36161543196496220842,  -0.36627252908604768233,  -0.37092046941298267848,  -0.37555913674750113218,  -0.38018841512316164932,  -0.38480818880824513295,
  -0.38941834230865052247,  -0.39401876037078076287,  -0.39860932798442311187,  -0.40318993038562678244,  -0.40776045305957026033,  -0.41232078174342468024,  -0.41687080242921104034,  -0.42141040136664820182,
  -0.42593946506599966728,  -0.43045788030090881282,  -0.43496553411123045629,  -0.43946231380585343285,  -0.44394810696551983975,  -0.44842280144563440025,  -0.45288628537906855387,  -0.45733844717895566490,
  -0.46177917554148295576,  -0.46620835944867272671,  -0.47062588817115835749,  -0.47503165127095098308,  -0.47942553860420311640,  -0.48380744032396016951,  -0.48817724688290742296,  -0.49253484903610883494,
  -0.49688013784373685766,  -0.50121300467379792387,  -0.50553334120484727521,  -0.50984103942869607451,  -0.51413599165311318906,  -0.51841809050451703733,  -0.52268722893065910906,  -0.52694330020330160114,
  -0.53118619792088350717,  -0.53541581601118337641,  -0.53963204873396963812,  -0.54383479068364282139,  -0.54802393679187377806,  -0.55219938233022769491,  -0.55636102291278377585,  -0.56050875449874415501,
  -0.56464247339503548240,  -0.56876207625890007336,  -0.57286746010048128497,  -0.57695852228539701301,  -0.58103516053730530633,  -0.58509727294046220969,  -0.58914475794226950356,  -0.59317751435581278496,
  -0.59719544136239222087,  -0.60119843851404120016,  -0.60518640573603954547,  -0.60915924332941506769,  -0.61311685197343401832,  -0.61705913272808676773,  -0.62098598703655971676,  -0.62489731672769976978,
  -0.62879302401846870474,  -0.63267301151638644097,  -0.63653718222196797871,  -0.64038543953114723806,  -0.64421768723769123888,  -0.64803382953560739743,  -0.65183377102153672311,  -0.65561741669714024283,
  -0.65938467197147310195,  -0.66313544266334978339,  -0.66686963500369800251,  -0.67058715563790372016,  -0.67428791162814527560,  -0.67797181045571497382,  -0.68163876002333423365,  -0.68528866865745496906,
  -0.68892144511055120049,  -0.69253699856340145136,  -0.69613523862735682268,  -0.69971607534660351657,  -0.70327941920041048274,  -0.70682518110536607381,  -0.71035327241760792827,  -0.71386360493503686619,
  -0.71735609089952279138,  -0.72083064299909871409,  -0.72428717437014267233,  -0.72772559859955054939,  -0.73114582972689612372,  -0.73454778224657879537,  -0.73793137110996287475,  -0.74129651172750310462,
  -0.74464311997085930184,  -0.74797111217499967495,  -0.75128040514029281738,  -0.75457091613458637802,  -0.75784256289527696104,  -0.76109526363136648097,  -0.76432893702550519510,  -0.76754350223602707537,
  -0.77073887889896930403,  -0.77391498713008166632,  -0.77707174752682406371,  -0.78020908117035037144,  -0.78332690962748341423,  -0.78642515495267417691,  -0.78950373968995057883,  -0.79256258687485459102,
  -0.79560162003636603067,  -0.79862076319881414310,  -0.80161994088377730439,  -0.80459907811196917926,  -0.80755810040511433190,  -0.81049693378780995889,  -0.81341550478937396651,  -0.81631374044568350001,
  -0.81919156830099826294,  -0.82204891640977173495,  -0.82488571333844995515,  -0.82770188816725775993,  -0.83049737049197047689,  -0.83327209042567607078,  -0.83602597860052074719,  -0.83875896616944312090,
  -0.84147098480789661590,  -0.84416196671555643327,  -0.84683184461801519483,  -0.84948055176846437586,  -0.85210802194936297038,  -0.85471418947409338873,  -0.85729898918860358847,  -0.85986235647303466134,
  -0.86240422724333842819,  -0.86492453795287804752,  -0.86742322559401685567,  -0.86990022769969410632,  -0.87235548234498638820,  -0.87478892814865483185,  -0.87720050427468176935,  -0.87959015043378918630,
  -0.88195780688494751498,  -0.88430341443686910630,  -0.88662691444948726893,  -0.88892824883542254089,  -0.89120736006143541630,  -0.89346419114986364018,  -0.89569868568004784581,  -0.89791078778974076080,
  -0.90010044217650508891,  -0.90226759409909518261,  -0.90441218937882594808,  -0.90653417440092687318,  -0.90863349611588339894,  -0.91071010204076130456,  -0.91276394026052121156,  -0.91479495942931421393,
  -0.91680310877176696138,  -0.91878833808425064422,  -0.92075059773613565639,  -0.92268983867103304686,  -0.92460601240802031686,  -0.92649907104285411652,  -0.92836896724916673218,  -0.93021565427965069439,
  -0.93203908596722639945,  -0.93383921672619663035,  -0.93561600155338597862,  -0.93736939602926661053,  -0.93909935631906760189,  -0.94080583917387217152,  -0.94248880193169759512,  -0.94414820251856268474,
  -0.94578399944953905898,  -0.94739615182978875740,  -0.94898461935558620084,  -0.95054936231532616286,  -0.95209034159051575408,  -0.95360751865675374983,  -0.95510085558469226541,  -0.95657031504098599672,
  -0.95801586028922502969,  -0.95943745519085332774,  -0.96083506420607267540,  -0.96220865239473030162,  -0.96355818541719306936,  -0.96488362953520556697,  -0.96618495161273409977,  -0.96746211911679436124,
  -0.96871510011826533759,  -0.96994386329268711400,  -0.97114837792104458103,  -0.97232861389053459877,  -0.97348454169531939417,  -0.97461613243726408218,  -0.97572335782665908788,  -0.97680619018292724753,
  -0.97786460243531625469,  -0.97889856812357467497,  -0.97990806139861430513,  -0.98089305702315576774,  -0.98185353037235978402,  -0.98278945743444268146,  -0.98370081481127658041,  -0.98458757971897459260,
  -0.98544972998846025458,  -0.98628724406602152897,  -0.98710010101385037284,  -0.98788828051056520874,  -0.98865176285171985082,  -0.98939052895029533374,  -0.99010456033717775259,  -0.99079383916161978263,
  -0.99145834819168643381,  -0.99209807081468681655,  -0.99271299103758847693,  -0.99330309348741807618,  -0.99386836341164486175,  -0.99440878667855037154,  -0.99492434977758092973,  -0.99541503981968604275,
  -0.99588084453764003090,  -0.99632175228634944908,  -0.99673775204314341014,  -0.99712883340804969734,  -0.99749498660405444550,  -0.99783620247734694519,  -0.99815247249754812664,  -0.99844378875792394457,
  -0.99871014397558299791,  -0.99895153149165882844,  -0.99916794527147601013,  -0.99935937990470136150,  -0.99952583060547905980,  -0.99966729321255021201,  -0.99978376418935699377,  -0.99987524062413102310,
  -0.99994172022996630211,  -0.99998320134487606037,  -0.99999968293183461032,  -0.99999116457880310449,  -0.99995764649874008256,  -0.99989912952959558723,  -0.99981561513429084709,  -0.99970710540068152827,
  -0.99957360304150510988,  -0.99941511139431382649,  -0.99923163442139051327,  -0.99902317670964990715,  -0.99878974347052396077,  -0.99853134053983161333,  -0.99824797437763246322,  -0.99793965206806589663,
  -0.99760638131917367399,  -0.99724817046270708421,  -0.99686502845391877781,  -0.99645696487133927910,  -0.99602398991653673388,  -0.99556611441386244632,  -0.99508334981018020660,  -0.99457570817457985335,
  -0.99404320219807595915,  -0.99348584519329008469,  -0.99290365109411848898,  -0.99229663445538318634,  -0.99166481045246857029,  -0.99100819488094182841,  -0.99032680415615803593,  -0.98962065531284981734,
  -0.98888976600470146483,  -0.98813415450390762462,  -0.98735383970071644022,  -0.98654884110295737454,  -0.98571917883555348894,  -0.98486487364001817912,  -0.98398594687393692304,  -0.98308242051043293053,
  -0.98215431713761847110,  -0.98120165995802932635,  -0.98022447278804547555,  -0.97922278005729512795,  -0.97819660680804465525,  -0.97714597869457153756,  -0.97607092198252420889,  -0.97497146354826413894,
  -0.97384763087819514737,  -0.97269945206807539861,  -0.97152695582231529681,  -0.97033017145326005970,  -0.96910912888045630531,  -0.96786385862990509388,  -0.96659439183329753931,  -0.96530076022723765305,
  -0.96398299615244809058,  -0.96264113255296213101,  -0.96127520297529989168,  -0.95988524156762966566,  -0.95847128307891416021,  -0.95703336285804208039,  -0.95557151685294383636,  -0.95408578160969381710,
  -0.95257619427159534453,  -0.95104279257825341531,  -0.94948561486463034509,  -0.94790470006008820114,  -0.94630008768741435965,  -0.94467181786183496150,  -0.94301993129001049354,  -0.94134446926901937935,
  -0.93964547368532491678,  -0.93792298701372800451,  -0.93617705231630599094,  -0.93440771324133520270,  -0.93261501402220048362,  -0.93079899947628874646,  -0.92895971500386931297,  -0.92709720658695793372,
  -0.92521152078816815134,  -0.92330270474954678761,  -0.92137080619139533066,  -0.91941587341107711140,  -0.91743795528180982490,  -0.91543710125144361900,  -0.91341336134122519397,  -0.91136678614454669223,
  -0.90929742682568159839,  -0.90720533511850520725,  -0.90509056332520076982,  -0.90295316431495353804,  -0.90079319152262726789,  -0.89861069894742917619,  -0.89640574115155979840,  -0.89417837325884952371,
  -0.89192865095337958703,  -0.88965663047809040442,  -0.88736236863337547565,  -0.88504592277566129788,  -0.88270735081597395677,  -0.88034671121849061848,  -0.87796406299907814308,  -0.87555946572381770920,
  -0.87313297950751633802,  -0.87068466501220309617,  -0.86821458344561253107,  -0.86572279655965511669,  -0.86320936664887359946,  -0.86067435654888468921,  -0.85811782963480887076,  -0.85553984981968544954,
  -0.85294048155287616186,  -0.85031978981845190990,  -0.84767784013356972661,  -0.84501469854683375349,  -0.84233043163664556019,  -0.83962510650953781077,  -0.83689879079849771593,  -0.83415155266127583022,
  -0.83138346077868308104,  -0.82859458435287203226,  -0.82578499310560804503,  -0.82295475727652578346,  -0.82010394762137406310,  -0.81723263541024548928,  -0.81434089242579588142,  -0.81142879096144915341,
  -0.80849640381958998159,  -0.80554380430974481531,  -0.80257106624674723339,  -0.79957826394889397470,  -0.79656547223608642483,  -0.79353276642796100049,  -0.79048022234200465697,  -0.78740791629166062560,
  -0.78431592508441982936,  -0.78120432601990186239,  -0.77807319688792120349,  -0.77492261596654288258,  -0.77175266202012560157,  -0.76856341429735364201,  -0.76535495252925345167,  -0.76212735692720223746,
  -0.75888070818092168146,  -0.75561508745646188689,  -0.75233057639417066920,  -0.74902725710665341019,  -0.74570521217671992265,  -0.74236452465532121181,  -0.73900527805947069382,  -0.73562755637015875276,
  -0.73223144403025131055,  -0.72881702594237995907,  -0.72538438746681943581,  -0.72193361441935266498,  -0.71846479306912613971,  -0.71497801013649253665,  -0.71147335279084422677,  -0.70795090864843213119,
  -0.70441076577017613936,  -0.70085301265946364779,  -0.69727773825993766277,  -0.69368503195327169131,  -0.69007498355693630554,  -0.68644768332195305049,  -0.68280322193063958114,  -0.67914169049434047754,
  -0.67546318055115084356,  -0.67176778406362758211,  -0.66805559341649090044,  -0.66432670141431326982,  -0.66058120127920061382,  -0.65681918664846095091,  -0.65304075157226471049,  -0.64924599051129161520,
  -0.64543499833437067981,  -0.64160787031610766462,  -0.63776470213450353608,  -0.63390558986856326840,  -0.63003062999589209969,  -0.62613991939028512679,  -0.62223355531930457651,  -0.61831163544184919445,
  -0.61437425780571164324,  -0.61042152084512746324,  -0.60645352337831459621,  -0.60247036460500380528,  -0.59847214410395643824,  -0.59445896183047686190,  -0.59043091811391257284,  -0.58638811365514731389,
  -0.58233064952408175596,  -0.57825862715710785178,  -0.57417214835457219824,  -0.57007131527823284856,  -0.56595623044870269069,  -0.56182699674288816283,  -0.55768371739141653354,  -0.55352649597605652065,
  -0.54935543642712658663,  -0.54517064302089812688,  -0.54097222037698844410,  -0.53676027345574461869,  -0.53253490755562105097,  -0.52829622831054467991,  -0.52404434168727598298,  -0.51977935398275876278,
  -0.51550137182146404946,  -0.51121050215272290096,  -0.50690685224805331899,  -0.50259052969847872738,  -0.49826164241183845682,  -0.49392029861008907021,  -0.48956660682659941530,  -0.48520067590343696207,
  -0.48082261498864814486,  -0.47643253353352743584,  -0.47203054128988253257,  -0.46761674830728994223,  -0.46319126493034507019,  -0.45875420179590142844,  -0.45430566983030634676,  -0.44984578024662685847,
  -0.44537464454187103424,  -0.44089237449419821369,  -0.43639908216012618380,  -0.43189487987172925365,  -0.42737988023382966762,  -0.42285419612118396726,  -0.41831794067565886142,  -0.41377122730340420986,
  -0.40921416967201718062,  -0.40464688170770196640,  -0.40006947759241939799,  -0.39548207176103394866,  -0.39088477889845207880,  -0.38627771393675675027,  -0.38166099205233156022,  -0.37703472866298326505,
  -0.37239903942505520051,  -0.36775404023053764879,  -0.36309984720416821347,  -0.35843657670053008513,  -0.35376434530114259092,  -0.34908326981154819135,  -0.34439346725838987373,  -0.33969505488648726876,
  -0.33498815015590455157,  -0.33027287073901562264,  -0.32554933451755990736,  -0.32081765957969693437,  -0.31607796421705369738,  -0.31133036692176702109,  -0.30657498638352281839,  -0.30181194148658646581,
  -0.29704135130683229082,  -0.29226333510876589816,  -0.28747801234254427571,  -0.28268550264098690761,  -0.27788592581658666525,  -0.27307940185851381498,  -0.26826605092961780530,  -0.26344599336342072737,
  -0.25861934966111072010,  -0.25378624048852843620,  -0.24894678667315245368,  -0.24410110920107558341,  -0.23924932921398228691,  -0.23439156800611909981,  -0.22952794702126408377,  -0.22465858784968809059,
  -0.21978361222511683115,  -0.21490314202168656066,  -0.21001729925089901441,  -0.20512620605856862754,  -0.20022998472177039320,  -0.19532875764578278011,  -0.19042264736102693101,  -0.18551177652000533369,
  -0.18059626789423280369,  -0.17567624437116896585,  -0.17075182895114521253,  -0.16582314474429141193,  -0.16089031496745564986,  -0.15595346294112538699,  -0.15101271208634373111,  -0.14606818592162557069,
  -0.14112000805986710250,  -0.13616830220525713568,  -0.13121319215018367732,  -0.12625480177214090660,  -0.12129325503062962643,  -0.11632867596405992161,  -0.11136118868664945936,  -0.10639091738532231723,
  -0.10141798631660174645,  -0.09644251980350543318,  -0.09146464223243663816,  -0.08648447805007625222,  -0.08150215176026900932,  -0.07651778792091265546,  -0.07153151114084313478,  -0.06654344607672113554,
  -0.06155371742991302270,  -0.05656244994337508020,  -0.05156976839853451289,  -0.04657579761216946307,  -0.04158066243329036626,  -0.03658448774001610282,  -0.03158739843645377854,  -0.02658951944957526833,
  -0.02159097572609583807,  -0.01659189222934778080,  -0.01159239393615815392,  -0.00659260583372344670,  -0.00159265291648670571,   0.00340733981698999704,   0.00840724736714873987,   0.01340694473656162643,
   0.01840630693305393001,   0.02340520897283157251,   0.02840352588360391117,   0.03340113270770895398,   0.03839790450523550280,   0.04339371635714930203,   0.04838844336841426758,   0.05338196067111569687,
   0.05837414342758021069,   0.06336486683349934479,   0.06835400612104790274,   0.07334143656200353689,   0.07832703347086542034,   0.08331067220796961603,   0.08829222818260772099,   0.09327157685613979288,
   0.09824859374510880317,   0.10322315442435085753,   0.10819513453010849713,   0.11316440976313804634,   0.11813085589181793189,   0.12309434875525272768,   0.12805476426637979470,   0.13301197841506973152,
   0.13796586727122742144,   0.14291630698788859721,   0.14786317380431862611,   0.15280634404910475865,   0.15774569414324876582,   0.16268110060325466359,   0.16761244004421843590,   0.17253958918291092961,
   0.17746242484086069413,   0.18238082394743185266,   0.18729466354290330576,   0.19220382078154110705,   0.19710817293466997846,   0.20200759739374196666,   0.20690197167339988149,   0.21179117341454209433,
   0.21667508038737973153,   0.22155357049449328488,   0.22642652177388328250,   0.23129381240202195880,   0.23615532069689712524,   0.24101092512105504184,   0.24586050428463715467,   0.25070393694841736076,
   0.25554110202683133490,   0.26037187859100452414,   0.26519614587177353648,   0.27001378326270797370,   0.27482467032312413169,   0.27962868678109636944,   0.28442571253646264928,   0.28921562766382935550,
   0.29399831241556773076,   0.29877364722480853620,   0.30354151270842943955,   0.30830178967004207014,   0.31305435910297030322,   0.31779910219322587972,   0.32253590032247908548,   0.32726463507102254713,
   0.33198518822073419532,   0.33669744175803123509,   0.34140127787682106320,   0.34609657898144485788,   0.35078322768961994749,   0.35546110683537274211,   0.36013009947196866767,   0.36479008887483416190,
   0.36944095854447722704,   0.37408259220939837908,   0.37871487382899815533,   0.38333768759647646185,   0.38795091794173042210,   0.39255444953424156740,   0.39714816728596030737,   0.40173195635418124105,
   0.40630570214441691368,   0.41086929031326063777,   0.41542260677124637214,   0.41996553768569905296,   0.42449796948358270443,   0.42901978885433855737,   0.43353088275271783880,   0.43803113840160834425,
   0.44252044329485257235,   0.44699868520006236228,   0.45146575216142326159,   0.45592153250249434215,   0.46036591482899841266,   0.46479878803160906697,   0.46922004128872724094,   0.47362956406925205144,
   0.47802724613534297582,   0.48241297754517775687,   0.48678664865569953868,   0.49114815012535872896,   0.49549737291684503582,   0.49983420829981556333,   0.50415854785361158275,   0.50847028346996991921,
   0.51276930735572390230,   0.51705551203550070838,   0.52132879035440660154,   0.52558903548070656786,   0.52983614090849351363,   0.53407000046035324470,   0.53829050829001767742,   0.54249755888501083323,
   0.54669104706928728366,   0.55087086800586004820,   0.55503691719942394034,   0.55918909049896592389,   0.56332728410037014033,   0.56745139454901150078,   0.57156131874234383794,   0.57565695393247651168,
   0.57973819772874324308,   0.58380494810026106745,   0.58785710337848284812,   0.59189456225973779979,   0.59591722380776435131,   0.59992498745623268341,   0.60391775301126071618,   0.60789542065391743986,
   0.61185789094271936239,   0.61580506481611496650,   0.61973684359496328256,   0.62365312898499980498,   0.62755382307929374885,   0.63143882836069553655,   0.63530804770427573569,   0.63916138437975222875,
   0.64299874205390883386,   0.64682002479300404474,   0.65062513706516744705,   0.65441398374279102779,   0.65818647010490505256,   0.66194250183954728151,   0.66568198504611930666,   0.66940482623773611692,
   0.67311093234356178527,   0.67680021071113694031,   0.68047256910869413637,   0.68412791572746478597,   0.68776615918397387972,   0.69138720852232482539,   0.69499097321647207437,   0.69857736317248630975,
   0.70214628873080553451,   0.70569766066847683383,   0.70923139020138625810,   0.71274738898647960195,   0.71624556912397063790,   0.71972584315953824774,   0.72318812408651222956,   0.72663232534805011209,
   0.73005836083929964708,   0.73346614490955241994,   0.73685559236438336050,   0.74022661846778314843,   0.74357913894427474233,   0.74691306998102069414,   0.75022832822991902813,   0.75352483080968579721,
   0.75680249530792831347,   0.76006123978320494494,   0.76330098276707347704,   0.76652164326612803880,   0.76972314076402448269,   0.77290539522349099855,   0.77606832708833239920,   0.77921185728541675353,
   0.78233590722665280470,   0.78544039881095495392,   0.78852525442619503249,   0.79159039695114352675,   0.79463574975739748041,   0.79766123671129407491,   0.80066678217581777055,   0.80365231101248835177,
   0.80661774858324053472,   0.80956302075228947501,   0.81248805388798428506,   0.81539277486464900591,   0.81827711106441036737,   0.82114099037901422395,   0.82398434121162578148,   0.82680709247862294031,
   0.82960917361137087589,   0.83239051455798740431,   0.83515104578509358202,   0.83789069827955253711,   0.84060940355019453385,   0.84330709362953004682,   0.84598370107544651475,   0.84863915897289776691,
   0.85127340093557457568,   0.85388636110756510611,   0.85647797416500115464,   0.85904817531769128713,   0.86159690031074054328,   0.86412408542615726237,   0.86662966748444436593,   0.86911358384618120354,
   0.87157577241358819009,   0.87401617163207945271,   0.87643472049180148886,   0.87883135852915883479,   0.88120602582832530114,   0.88355866302274232993,   0.88588921129660269660,   0.88819761238632033429,
   0.89048380858198861176,   0.89274774272882151394,   0.89498935822858360911,   0.89720859904100391802,   0.89940540968517768139,   0.90157973524095347262,   0.90373152135030576648,   0.90586071421869318598,
   0.90796726061640542493,   0.91005110787989218490,   0.91211220391308034383,   0.91415049718867658068,   0.91616593674945501213,   0.91815847220953161756,   0.92012805375562400911,   0.92207463214829554765,
   0.92399815872318802334,   0.92589858539223723888,   0.92777586464487560303,   0.92962994954921940316,   0.93146079375324264404,   0.93326835148593556557,   0.93505257755844939371,   0.93681342736522454917,
   0.93855085688510786479,   0.94026482268245192842,   0.94195528190820099201,   0.94362219230096244793,   0.94526551218806342813,   0.94688520048659219341,   0.94848121670442564479,   0.95005352094124184692,
   0.95160207388951612018,   0.95312683683550569747,   0.95462777166021639541,   0.95610484084035574082,   0.95755800744927122015,   0.95898723515787320792,   0.96039248823554335122,   0.96177373155102841018,
   0.96313093057331666813,   0.96446405137250368345,   0.96577306062063883463,   0.96705792559255909779,   0.96831861416670717002,   0.96955509482593427162,   0.97076733665828829345,   0.97195530935778684523,
   0.97311898322517387250,   0.97425832916866350608,   0.97537331870466648098,   0.97646392395850256651,   0.97753011766509712022,   0.97857187316966298685,   0.97958916442836685423,   0.98058196600898028805,
   0.98155025309151555657,   0.98249400146884580121,   0.98341318754731077423,   0.98430778834730647819,   0.98517778150385948432,   0.98602314526718615184,   0.98684385850323652623,   0.98763990069422247231,
   0.98841125193913059732,   0.98915789295421985283,   0.98987980507350392667,   0.99057697024921731455,   0.99124937105226695877,   0.99189699067266778876,   0.99251981291996316248,   0.99311782222362920969,
   0.99369100363346452021,   0.99423934281996362294,   0.99476282607467558794,   0.99526144031054608607,   0.99573517306224534895,   0.99618401248647925339,   0.99660794736228552892,   0.99700696709131431117,
   0.99738106169809326307,   0.99773022183027670895,   0.99805443875887944749,   0.99835370437849513259,   0.99862801120749888906,   0.99887735238823427419,   0.99910172168718480723,   0.99930111349512962260,
   0.99947552282728402417,   0.99962494532342371922,   0.99974937724799395333,   0.99984881549020332425,   0.99992325756410094240,   0.99997270160863860333,   0.99999714638771797226,   0.99999659129022078208,
   0.99997103633002448753,   0.99992048214600159906,   0.99984493000200436175,   0.99974438178683222578,   0.99961884001418532808,   0.99946830782260165371,   0.99929278897537787696,   0.99909228786047621362,
   0.99886680949041417588,   0.99861635950213900603,   0.99834094415688756641,   0.99804057034002902071,   0.99771524556089319358,   0.99736497795258272081,   0.99698977627176943450,   0.99658964989847598215,
   0.99616460883584057040,   0.99571466370986794203,   0.99523982576916258935,   0.99474010688464831187,   0.99421551954927123163,   0.99366607687768748747,   0.99309179260593527516,   0.99249268109109134439,
   0.99186875731091250774,   0.99122003686346060736,   0.99054653596671304872,   0.98984827145815734717,   0.98912526079436957627,   0.98837752205057904931,   0.98760507392021512629,   0.98680793571444103129,
   0.98598612736167012827,   0.98513966940706865216,   0.98426858301204134261,   0.98337288995370264466,   0.98245261262433225546,   0.98150777403081579386,   0.98053839779406870569,   0.97954450814844640227,
   0.97852612994113830069,   0.97748328863154654300,   0.97641601029064950534,   0.97532432160035020807,   0.97420824985280907171,   0.97306782294976124081,   0.97190306940182058515,   0.97071401832776471608,
   0.96950069945380856762,   0.96826314311286099112,   0.96700138024376580681,   0.96571544239052919956,   0.96440536170153046136,   0.96307117092871830089,   0.96171290342679316421,   0.96033059315237145892,
   0.95892427466313823192,   0.95749398311698219466,   0.95603975427111775875,   0.95456162448119030728,   0.95305963070036747720,   0.95153381047841534279,   0.94998420196076049926,   0.94841084388753493783,
   0.94681377559260859744,   0.94519303700260559609,   0.94354866863590625137,   0.94188071160163422402,   0.94018920759862834036,   0.93847419891440064799,   0.93673572842407859529,   0.93497383958933455439,
   0.93318857645729724748,   0.93137998365945207091,   0.92954810641052476594,   0.92769299050735110068,   0.92581468232773200810,   0.92391322882927429117,   0.92198867754821589582,   0.92004107659823930465,
   0.91807047466926661183,   0.91607692102624327379,   0.91406046550790653882,   0.91202115852553944375,   0.90995905106171026677,   0.90787419466899810239,   0.90576664146870400351,   0.90363644414954891193,
   0.90148365596635438024,   0.89930833073871296879,   0.89711052284964198922,   0.89489028724422425842,   0.89264767942823419755,   0.89038275546675049732,   0.88809557198275379530,   0.88578618615571291794,
   0.88345465572015269284,   0.88110103896421276826,   0.87872539472818933515,   0.87632778240306463680,   0.87390826192902193448,   0.87146689379394692843,   0.86900373903191607816,   0.86651885922166937970,
   0.86401231648507381689,   0.86148417348556682871,   0.85893449342659156098,   0.85636334005001668590,   0.85377077763454289894,   0.85115687099409531591,   0.84852168547620410166,   0.84586528696036911157,
   0.84318774185641620633,   0.84048911710283280563,   0.83776948016509722450,   0.83502889903399135640,   0.83226744222390069972,   0.82948517877110161667,   0.82668217823203571371,   0.82385851068156967791,
   0.82101424671124645371,   0.81814945742751654656,   0.81526421444996288734,   0.81235858990950959857,   0.80943265644661888114,   0.80648648720947491153,   0.80352015585215519344,   0.80053373653278914190,
   0.79752730391170367774,   0.79450093314955871904,   0.79145469990546535310,   0.78838868033509590383,   0.78530295108877989918,   0.78219758930958782628,   0.77907267263140256297,   0.77592827917697804185,
   0.77276448755598647899,   0.76958137686305472247,   0.76637902667578372551,   0.76315751705276135830,   0.75991692853156034282,   0.75665734212672508541,   0.75337883932774563078,   0.75008150209702162403,
   0.74676541286781195073,   0.74343065454217460708,   0.74007731048889391356,   0.73670546454139651527,   0.73331520099565583592,   0.72990660460808376442,   0.72647976059341234922,   0.72303475462256339146,
   0.71957167282050704671,   0.71609060176410799237,   0.71259162847996104784,   0.70907484044221602559,   0.70554032557039114693,   0.70198817222717391218,   0.69841846921621286715,   0.69483130577989704602,
   0.69122677159712608841,   0.68760495678106647865,   0.68396595187690023554,   0.68030984785955983529,   0.67663673613145614016,   0.67294670852019056184,   0.66923985727626122966,   0.66551627507075594714,
   0.66177605499303648884,   0.65801929054840968547,   0.65424607565579095958,   0.65045650464535575974,   0.64665067225618266811,   0.64282867363388296322,   0.63899060432822296640,   0.63513656029073550791,
   0.63126663787232040193,   0.62738093382083737204,   0.62347954527868487684,   0.61956256978037316241,   0.61563010525008554641,   0.61168224999923104246,   0.60771910272398499409,   0.60374076250282282530,
   0.59974732879404257790,   0.59573890143327967728,   0.59171558063100893055,   0.58767746697004086265,   0.58362466140300639506,   0.57955726524983441905,   0.57547538019521626840,   0.57137910828606597313,
   0.56726855192896752378,   0.56314381388761636238,   0.55900499728024832802,   0.55485220557706316225,   0.55068554259763680125,   0.54650511250832733978,   0.54231101981966889358,   0.53810336938376035487,
   0.53388226639164337861,   0.52964781637067259723,   0.52540012518187872992,   0.52113929901731992356,   0.51686544439742831969,   0.51257866816834640744,   0.50827907749925749226,   0.50396677987970384116,
   0.49964188311690155286,   0.49530449533304393706,   0.49095472496260045281,   0.48659268074960349004,   0.48221847174493104315,   0.47783220730358016981,   0.47343399708193417696,   0.46902395103501909324,
   0.46460217941375647754,   0.46016879276220612471,   0.45572390191480421917,   0.45126761799359005334,   0.44680005240542952638,   0.44232131683922926157,   0.43783152326314600522,   0.43333078392178486782,
   0.42881921133339495622,   0.42429691828705606849,   0.41976401783985833882,   0.41522062331407771918,   0.41066684829434035864,   0.40610280662478442926,   0.40152861240621368077,   0.39694437999324616584,
   0.39235022399145291772,   0.38774625925449479613,   0.38313260088125000724,   0.37850936421293840395,   0.37387666483023551667,   0.36923461855038458568,   0.36458334142430037783,   0.35992294973366972810,
   0.35525355998804170055,   0.35057528892191675007,   0.34588825349182744651,   0.34119257087341625656,   0.33648835845850372239,   0.33177573385215508583,   0.32705481486973969618,   0.32232571953398708731,
   0.31758856607203389544,   0.31284347291246999978,   0.30809055868237716913,   0.30332994220436321209,   0.29856174249359301864,   0.29378607875481060896,   0.28900307037936062704,   0.28421283694220295102,
   0.27941549819892491646,   0.27461117408274476892,   0.26979998470151522749,   0.26498205033471977643,   0.26015749143046751346,   0.25532642860247933836,   0.25048898262707436357,   0.24564527444014955249,
   0.24079542513415819194,   0.23593955595507989931,   0.23107778829939124021,   0.22621024371102996242,   0.22133704387835811955,   0.21645831063111725667,   0.21157416593738448407,   0.20668473190052233379,
   0.20179013075612792227,   0.19689048486897448020,   0.19198591672995404811,   0.18707654895301459308,   0.18216250427209446094,   0.17724390553805557946,   0.17232087571560969486,   0.16739353788024594061,
   0.16246201521515318822,   0.15752643100814200938,   0.15258690864856014335,   0.14764357162420929659,   0.14269654351825716843,   0.13774594800614961554,   0.13279190885251615506,   0.12783454990807766039,
   0.12287399510654904711,   0.11791036846154288875,   0.11294379406346635730,   0.10797439607642073112,   0.10300229873509640643,   0.09802762634166883871,   0.09305050326268833605,   0.08807105392597264215,
   0.08308940281749539747,   0.07810567447827571064,   0.07311999350126208164,   0.06813248452821923928,   0.06314327224661175908,   0.05815248138648638349,   0.05316023671735556344,   0.04816666304507556673,
   0.04317188520872811824,   0.03817602807749854305,   0.03317921654755580374,   0.02818157553892746553,   0.02318322999237843948,   0.01818430486628662066,   0.01318492513352068594,   0.00818521577831312665,
   0.00318530179313742355,  -0.00181469182441765112,  -0.00681464007477118605,  -0.01181441795947778088,  -0.01681390048435072240,  -0.02181296266258772251,  -0.02681147951789380687,  -0.03180932608760837083,
  -0.03680637742582747868,  -0.04180250860652838518,  -0.04679759472669089287,  -0.05179151090942261254,  -0.05678413230707906462,  -0.06177533410438534184,  -0.06676499152155691841,  -0.07175297981741735054,
  -0.07673917429251948807,  -0.08172345029226112112,  -0.08670568321000234058,  -0.09168574849017877004,  -0.09666352163141823939,  -0.10163887818965149090,  -0.10661169378122412055,  -0.11158184408600446691,
  -0.11654920485049420631,  -0.12151365189093295271,  -0.12647506109640369032,  -0.13143330843193384849,  -0.13638826994159863881,  -0.14133982175161846628,  -0.14628784007345638218,  -0.15123220120691119317,
  -0.15617278154321248551,  -0.16110945756810918228,  -0.16604210586495821156,  -0.17097060311780823416,  -0.17589482611448500893,  -0.18081465174967009668,  -0.18572995702797928663,  -0.19064061906703580473,
  -0.19554651510054482655,  -0.20044752248136102346,  -0.20534351868455516521,  -0.21023438131047758604,  -0.21511998808781651604,  -0.22000021687665741177,  -0.22487494567153470948,  -0.22974405260448288457,
  -0.23460741594808134924,  -0.23946491411850023834,  -0.24431642567853828485,  -0.24916182934065958521,  -0.25400100397002411956,  -0.25883382858751863287,  -0.26366018237277932812,  -0.26847994466721347706,
  -0.27329299497701375898,  -0.27809921297617368197,  -0.28289847850949351171,  -0.28769067159558531221,  -0.29247567242987065894,  -0.29725336138757835203,  -0.30202361902673330318,  -0.30678632609114336871,
  -0.31154136351337924360,  -0.31628861241775330093,  -0.32102795412329032665,  -0.32575927014669442405,  -0.33048244220531186599,  -0.33519735222008639752,  -0.33990388231851365042,  -0.34460191483758617625,
  -0.34929133232673625908,  -0.35397201755076995733,  -0.35864385349280092363,  -0.36330672335717389965,  -0.36796051057238560178,  -0.37260509879399711375,  -0.37724037190754533544,  -0.38186621403144377362,
  -0.38648250951988066815,  -0.39108914296570845837,  -0.39568599920333130671,  -0.40027296331158268572,  -0.40484992061659924589,  -0.40941675669468591270,  -0.41397335737517892973,  -0.41851960874329868778,
  -0.42305539714299816856,  -0.42758060917980272864,  -0.43209513172364766298,  -0.43659885191170438867,  -0.44109165715120285389,  -0.44557343512224645288,  -0.45004407378061850320,  -0.45450346136058583646,
  -0.45895148637769117572,  -0.46338803763154118309,  -0.46781300420858479283,  -0.47222627548488838034,  -0.47662774112889999545,  -0.48101729110420810009,  -0.48539481567229114667,  -0.48976020539526338160,
  -0.49411335113860904711,  -0.49845414407391169798,  -0.50278247568157319325,  -0.50709823775352924624,  -0.51140132239595281760,  -0.51569162203195229033,  -0.51996902940425959727,  -0.52423343757791340813,
  -0.52848473994293165834,  -0.53272283021697686145,  -0.53694760244801220672,  -0.54115895101695243863,  -0.54535677064030252392,  -0.54954095637279054554,  -0.55371140360999160368,  -0.55786800809094105880,
  -0.56201066590074388873,  -0.56613927347317050121,  -0.57025372759324721716,  -0.57435392539983431970,  -0.57843976438820066122,  -0.58251114241258428184,  -0.58656795768874714359,  -0.59061010879651776317,
  -0.59463749468232940387,  -0.59865001466174472267,  -0.60264756842197342301,  -0.60663005602437913844,  -0.61059737790697954374,  -0.61454943488693414277,  -0.61848612816302472872,  -0.62240735931812363191,
  -0.62631303032165663858,  -0.63020304353205203185,  -0.63407730169918252727,  -0.63793570796679510693,  -0.64177816587493419220,  -0.64560457936235238208,  -0.64941485276891164347,  -0.65320889083797573083,
  -0.65698659871878983818,  -0.66074788196885403391,  -0.66449264655628281773,  -0.66822079886215701716,  -0.67193224568286247234,  -0.67562689423242239251,  -0.67930465214481527969,  -0.68296542747628530279,
  -0.68660912870763923799,  -0.69023566474653630376,  -0.69384494492976445112,  -0.69743687902550732804,  -0.70101137723559914239,  -0.70456835019777108720,  -0.70810770898788422123,  -0.71162936512215357876,
  -0.71513323055935862360,  -0.71861921770304615364,  -0.72208723940371910555,  -0.72553720896101603355,  -0.72896904012587693256,  -0.73238264710270173374,  -0.73577794455149403419,  -0.73915484758999416837,
  -0.74251327179580250970,  -0.74585313320848811713,  -0.74917434833169005426,  -0.75247683413520316531,  -0.75576050805705463631,  -0.75902528800556723354,  -0.76227109236141132875,  -0.76549783997964904181,
  -0.76870545019175651191,  -0.77189384280764572477,  -0.77506293811766757695,  -0.77821265689460439319,  -0.78134292039565123034,  -0.78445365036438186035,  -0.78754476903271153354,  -0.79061619912283220835,
  -0.79366786384915377628,  -0.79669968692021542189,  -0.79971159254059875909,  -0.80270350541282020629,  -0.80567535073921381361,  -0.80862705422380165565,  -0.81155854207414879209,  -0.81446974100321378742,
  -0.81736057823117291843,  -0.82023098148724815637,  -0.82308087901150606136,  -0.82591019955665734287,  -0.82871887238983588109,  -0.83150682729436709018,  -0.83427399457152406903,  -0.83702030504226743179,
  -0.83974569004898047542,  -0.84245008145717859005,  -0.84513341165721778125,  -0.84779561356598298616,  -0.85043662062856495432,  -0.85305636681992524917,  -0.85565478664654404106,  -0.85823181514806290426,
  -0.86078738789890174576,  -0.86332144100987662227,  -0.86583391112979046778,  -0.86832473544702148960,  -0.87079385169109158049,  -0.87324119813422318437,  -0.87566671359288317245,  -0.87807033742931006604,
  -0.88045200955303482004,  -0.88281167042237718157,  -0.88514926104593882883,  -0.88746472298407563795,  -0.88975799835036006868,  -0.89202902981302722996,  -0.89427776059640884387,  -0.89650413448235288794,
  -0.89870809581162691693,  -0.90088958948531416837,  -0.90304856096618524308,  -0.90518495628006578890,  -0.90729872201718442248,  -0.90938980533350777247,  -0.91145815395206175591,  -0.91350371616423864385,
  -0.91552644083109002704,  -0.91752627738460390550,  -0.91950317582897100888,  -0.92145708674183313125,  -0.92338796127551925341,  -0.92529575115826656617,  -0.92718040869542739379,  -0.92904188677066168456,
  -0.93088013884711362511,  -0.93269511896857837385,  -0.93448678176064647882,  -0.93625508243184163426,  -0.93799997677473923030,  -0.93972142116707157999,  -0.94141937257281860241,  -0.94309378854328340669,
  -0.94474462721815444244,  -0.94637184732654988650,  -0.94797540818805281493,  -0.94955526971372439249,  -0.95111139240710917964,  -0.95264373736522078850,  -0.95415226627951510441,  -0.95563694143684785320,
  -0.95709772572041729166,  -0.95853458261069279800,  -0.95994747618632647601,  -0.96133637112505265776,  -0.96270123270457030884,  -0.96404202680341100073,  -0.96535871990179211721,  -0.96665127908245462862,
  -0.96791967203148676635,  -0.96916386703913015577,  -0.97038383300057517999,  -0.97157953941673580456,  -0.97275095639501407696,  -0.97389805465004641860,  -0.97502080550443648299,  -0.97611918088947113858,
  -0.97719315334582312893,  -0.97824269602423696846,  -0.97926778268620007228,  -0.98026838770459978623,  -0.98124448606436232012,  -0.98219605336307969079,  -0.98312306581161901242,  -0.98402550023471724305,
  -0.98490333407156094303,  -0.98575654537634993524,  -0.98658511281884597732,  -0.98738901568490611282,  -0.98816823387700059023,  -0.98892274791471512785,  -0.98965253893523819073,  -0.99035758869383216929,
  -0.99103787956429001405,  -0.99169339453937521700,  -0.99232411723124747116,  -0.99293003187187267589,  -0.99351112331341595585,  -0.99406737702862180139,  -0.99459877911117622329,  -0.99510531627605480764,
  -0.99558697585985489464,  -0.99604374582111188108,  -0.99647561474060075692,  -0.99688257182162054448,  -0.99726460689026596995,  -0.99762171039567981712,  -0.99795387341029329065,  -0.99826108763004817170,
  -0.99854334537460498478,  -0.99880063958753495523,  -0.99903296383649597967,  -0.99924031231339405235,  -0.99942267983452803826,  -0.99958006184071934719,  -0.99971245439742595362,  -0.99981985419484109556,
  -0.99990225854797520899,  -0.99995966539672387352,  -0.99999207330591877163,  -0.99999948146536388194,  -0.99998188968985557423,  -0.99993929841918749446,  -0.99987170871813890738,  -0.99977912227644905041,
  -0.99966154140877416800,  -0.99951896905462955800,  -0.99935140877831696304,  -0.99915886476883430944,  -0.99894134183977201236,  -0.99869884542919173942,  -0.99843138159949140764,  -0.99813895703725263875,
  -0.99782157905307422574,  -0.99747925558138939017,  -0.99711199518026705224,  -0.99671980703119800182,  -0.99630270093886552640,  -0.99586068733090049587,  -0.99539377725761979399,  -0.99490198239175109407,
  -0.99438531502814031526,  -0.99384378808344475686,  -0.99327741509580969037,  -0.99268621022453029656,  -0.99207018824969783743,  -0.99142936457182928578,  -0.99076375521148341008,  -0.99007337680885953990,
  -0.98935824662338167634,  -0.98861838253326717041,  -0.98785380303507996924,  -0.98706452724326754211,  -0.98625057488968337349,  -0.98541196632309446812,  -0.98454872250867075945,  -0.98366086502746297171,
  -0.98274841607586183034,  -0.98181139846504350555,  -0.98084983562039951277,  -0.97986375158095095905,  -0.97885317099874735725,  -0.97781811913825045224,  -0.97675862187570339223,  -0.97567470569848213646,
  -0.97456639770443476145,  -0.97343372560120344783,  -0.97227671770553181219,  -0.97109540294255680681,  -0.96988981084508585351,  -0.96865997155285932241,  -0.96740591581179447012,  -0.96612767497322027399,
  -0.96482528099309083913,  -0.96349876643118781416,  -0.96214816445030626468,  -0.96077350881542522565,  -0.95937483389286415392,  -0.95795217464942283847,  -0.95650556665150909819,  -0.95503504606424649559,
  -0.95354064965057394598,  -0.95202241477032367722,  -0.95048037937928853136,  -0.94891458202827316804,  -0.94732506186212961374,  -0.94571185861877926637,  -0.94407501262821902355,  -0.94241456481151386626,
  -0.94073055667977245609,  -0.93902303033311051994,  -0.93729202845959747048,  -0.93553759433419036995,  -0.93375977181765068558,  -0.93195860535544849945,  -0.93013413997665261856,  -0.92828642129280103390,
  -0.92641549549676571740,  -0.92452140936159377116,  -0.92260421023933991691,  -0.92066394605988222111,  -0.91870066532972438633,  -0.91671441713078216651,  -0.91470525111915690353,  -0.91267321752389507505,
  -0.91061836714572963469,  -0.90854075135581380263,  -0.90644042209443387303,  -0.90431743186971202952,  -0.90217183375629328435,  -0.90000368139401865086,  -0.89781302898658432721,  -0.89559993130018611396,
  -0.89336444366215139734,  -0.89110662195955459008,  -0.88882652263782058188,  -0.88652420269931364594,  -0.88419971970191224564,  -0.88185313175757040760,  -0.87948449753086399561,  -0.87709387623752654850,
  -0.87468132764296424586,  -0.87224691206076765404,  -0.86979069035119904729,  -0.86731272391967317859,  -0.86481307471522173014,  -0.86229180522894477434,  -0.85974897849244813486,  -0.85718465807626731401,
  -0.85459890808828042896,  -0.85199179317210071982,  -0.84936337850546672623,  -0.84671372979860781705,  -0.84404291329260350274,  -0.84135099575772742675,  -0.83863804449177770106,  -0.83590412731839469629,
  -0.83314931258536495395,  -0.83037366916291421859,  -0.82757726644198292831,  -0.82476017433249360078,  -0.82192246326160212089,  -0.81906420417193759320,  -0.81618546851982831658,  -0.81328632827351565737,
  -0.81036685591135471096,  -0.80742712442000219575,  -0.80446720729259302285,  -0.80148717852690087859,  -0.79848711262348970319,  -0.79546708458385073648,  -0.79242716990852768433,  -0.78936744459522911743,
  -0.78628798513692810257,  -0.78318886851995150877,  -0.78007017222205310425,  -0.77693197421047766049,  -0.77377435294001228883,  -0.77059738735102401019,  -0.76740115686748722190,  -0.76418574139499750864,
  -0.76095122131877424021,  -0.75769767750165029074,  -0.75442519128205276502,  -0.75113384447196607230,  -0.74782371935488911596,  -0.74449489868377749513,  -0.74114746567897449303,  -0.73778150402613085213,
  -0.73439709787411278086,  -0.73099433183289752591,  -0.72757329097145850838,  -0.72413406081564013483,  -0.72067672734601673223,  -0.71720137699574493251,  -0.71370809664840229036,  -0.71019697363581579808,
  -0.70666809573587785476,  -0.70312155117035146645,  -0.69955742860266734162,  -0.69597581713570333406,  -0.69237680630955966699,  -0.68876048609931961320,  -0.68512694691279985015,  -0.68147627958829104511,
  -0.67780857539228600572,  -0.67412392601719872687,  -0.67042242357907078087,  -0.66670416061527193463,  -0.66296923008218189288,  -0.65921772535286937700,  -0.65544974021475732595,  -0.65166536886727777222,
  -0.64786470591951750286,  -0.64404784638785206319,  -0.64021488569357121179,  -0.63636591966049171898,  -0.63250104451256550231,  -0.62862035687146911034,  -0.62472395375419165209,  -0.62081193257060796054,
  -0.61688439112104398454,  -0.61294142759383130059,  -0.60898314056285207663,  -0.60500962898507726351,  -0.60102099219808879926,  -0.59701732991759859370,  -0.59299874223495496750,  -0.58896532961464087563,
  -0.58491719289176158370,  -0.58085443326952446164,  -0.57677715231670834140,  -0.57268545196512410378,  -0.56857943450706882604,  -0.56445920259276427533,  -0.56032485922779384779,  -0.55617650777052629607,
  -0.55201425192953201826,  -0.54783819576099013204,  -0.54364844366608755521,  -0.53944510038840820521,  -0.53522827101131453809,  -0.53099806095532275929,  -0.52675457597546326838,  -0.52249792215863943845,
  -0.51822820592097507131,  -0.51394553400515374797,  -0.50965001347775029661,  -0.50534175172655326769,  -0.50102085645788385637,  -0.49668743569389767201,  -0.49234159776988828394,  -0.48798345133157744469,
  -0.48361310533239909581,  -0.47923066903077560230,  -0.47483625198738627082,  -0.47042996406242826302,  -0.46601191541286945963,  -0.46158221648969754991,  -0.45714097803515413299,  -0.45268831107996920782,
  -0.44822432694058478297,  -0.44374913721637188058,  -0.43926285378684049032,  -0.43476558880884264013,  -0.43025745471376780626,  -0.42573856420473515927,  -0.42120903025377121054,  -0.41666896609898895765,
  -0.41211848524175564989,  -0.40755770144385583542,  -0.40298672872464680328,  -0.39840568135820858542,  -0.39381467387048585405,  -0.38921382103642837569,  -0.38460323787711647725,  -0.37998303965688906558,
  -0.37535334188046098891,  -0.37071426029003556879,  -0.36606591086241091482,  -0.36140840980608057720,  -0.35674187355832848167,  -0.35206641878231687004,  -0.34738216236417329696,  -0.34268922141006341597,
  -0.33798771324326665200,  -0.33327775540124238152,  -0.32855946563269122773,  -0.32383296189461174830,  -0.31909836234935112786,  -0.31435578536165070807,  -0.30960534949568974117,  -0.30484717351211659819,
  -0.30008137636508314117,  -0.29530807719926976951,  -0.29052739534690708023,  -0.28573945032479231010,  -0.28094436183130161444,  -0.27614224974339685037,  -0.27133323411363174937,  -0.26651743516714571092,
  -0.26169497329866164836,  -0.25686596906947500862,  -0.25203054320444007175,  -0.24718881658895158759,  -0.24234091026592280427,  -0.23748694543275927771,  -0.23262704343832818488,  -0.22776132577992797001,
  -0.22288991410024580619,  -0.21801293018431996962,  -0.21313049595649438683,  -0.20824273347737040640,  -0.20334976494075546194,  -0.19845171267060812692,  -0.19354869911797917270,  -0.18864084685795379226,
  -0.18372827858658200006,  -0.17881111711781472184,  -0.17388948538043255687,  -0.16896350641497262512,  -0.16403330337065250011,  -0.15909899950229147714,  -0.15416071816722845544,  -0.14921858282224129133,
  -0.14427271702045540991,  -0.13932324440825819001,  -0.13437028872220715958,  -0.12941397378593655354,  -0.12445442350706158174,  -0.11949176187408093452,  -0.11452611295327697061,  -0.10955760088561317112,
  -0.10458634988363424423,  -0.09961248422835543292,  -0.09463612826615905305,  -0.08965740640568498065,  -0.08467644311472041774,  -0.07969336291708821463,  -0.07470829038953377688,  -0.06972135015860976559,
  -0.06473266689756400349,  -0.05974236532321727799,  -0.05475057019284905457,  -0.04975740630107760437,  -0.04476299847674015953,  -0.03976747157977219421,  -0.03477095049808595628,  -0.02977356014444736479,
  -0.02477542545335675514,  -0.01977667137792019775,  -0.01477742288672922490,  -0.00977780496073574201,
};
