/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "lwip.h"
#include "tcp_echo_client.h"
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";
__IO uint32_t tcpFlag = 0U;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* Init LwIP */
    LWIP_Init();

    /* Infinite loop */
    while (1)
    {
        LWIP_Process();
    }
}

/**
 * @brief  EINT line detection callbacks
 *
 * @param  GPIO_Pin Specifies the pins connected EINT line
 *
 * @retval None
 */
void DAL_GPIO_EINT_Callback(uint16_t GPIO_Pin)
{
    if (GPIO_Pin == GPIO_PIN_10)
    {
        if (tcpFlag == 1U)
        {
            tcpFlag = 0U;

            /* Close the tcp connection with server */
            LOGI(tag, "Close TCP connection\r\n");
            tcp_echo_client_connection_close();
        }
    }

    if (GPIO_Pin == GPIO_PIN_11)
    {
        if (tcpFlag == 0U)
        {
            tcpFlag = 1U;

            /* Connects to the tcp echo client */
            LOGI(tag, "Connects TCP client\r\n");
            tcp_echo_client_connect();
        }
    }
}
