/**
 * @file        apm32f4xx_hash_cfg.c
 *
 * @brief       This file provides configuration support for HASH
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_hash_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
HASH_HandleTypeDef hhash;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initialize the HASH MSP
 *
 * @param  hhash HASH handle
 *
 * @retval None
 */
void DAL_HASH_MspInit(HASH_HandleTypeDef *hhash)
{
    /* Enable peripheral clock */
    __DAL_RCM_HASH_CLK_ENABLE();
}

/**
 * @brief  DeInitialize the HASH MSP
 *
 * @param  hhash HASH handle
 *
 * @retval None
 */
void DAL_HASH_MspDeInit(HASH_HandleTypeDef *hhash)
{
    /* Disable peripheral clock */
    __DAL_RCM_HASH_CLK_DISABLE();
}

/**
 * @brief   HASH configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_HASH_Config(void)
{
    hhash.Init.DataType = HASH_DATATYPE_8B;
    if (DAL_HASH_Init(&hhash) != DAL_OK)
    {
        Error_Handler();
    }
}
