/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"
#include <string.h>

/* Private macro **********************************************************/
#define HASH_INPUT_TABLE_SIZE           261U

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

static uint8_t sha1Output[20];

const uint8_t inputTable[HASH_INPUT_TABLE_SIZE] =
{
    0x54U, 0x68U, 0x65U, 0x20U, 0x68U, 0x61U, 0x73U, 0x68U,
    0x20U, 0x70U, 0x72U, 0x6FU, 0x63U, 0x65U, 0x73U, 0x73U,
    0x6FU, 0x72U, 0x20U, 0x69U, 0x73U, 0x20U, 0x61U, 0x20U,
    0x66U, 0x75U, 0x6CU, 0x6CU, 0x79U, 0x20U, 0x63U, 0x6FU,
    0x6DU, 0x70U, 0x6CU, 0x69U, 0x61U, 0x6EU, 0x74U, 0x20U,
    0x69U, 0x6DU, 0x70U, 0x6CU, 0x65U, 0x6DU, 0x65U, 0x6EU,
    0x74U, 0x61U, 0x74U, 0x69U, 0x6FU, 0x6EU, 0x20U, 0x6FU,
    0x66U, 0x20U, 0x74U, 0x68U, 0x65U, 0x20U, 0x73U, 0x65U,
    0x63U, 0x75U, 0x72U, 0x65U, 0x20U, 0x68U, 0x61U, 0x73U,
    0x68U, 0x20U, 0x61U, 0x6CU, 0x67U, 0x6FU, 0x72U, 0x69U,
    0x74U, 0x68U, 0x6DU, 0x20U, 0x28U, 0x53U, 0x48U, 0x41U,
    0x2DU, 0x31U, 0x29U, 0x2CU, 0x20U, 0x74U, 0x68U, 0x65U,
    0x20U, 0x4DU, 0x44U, 0x35U, 0x20U, 0x28U, 0x6DU, 0x65U,
    0x73U, 0x73U, 0x61U, 0x67U, 0x65U, 0x2DU, 0x64U, 0x69U,
    0x67U, 0x65U, 0x73U, 0x74U, 0x20U, 0x61U, 0x6CU, 0x67U,
    0x6FU, 0x72U, 0x69U, 0x74U, 0x68U, 0x6DU, 0x20U, 0x35U,
    0x29U, 0x20U, 0x68U, 0x61U, 0x73U, 0x68U, 0x20U, 0x61U,
    0x6CU, 0x67U, 0x6FU, 0x72U, 0x69U, 0x74U, 0x68U, 0x6DU,
    0x20U, 0x61U, 0x6EU, 0x64U, 0x20U, 0x74U, 0x68U, 0x65U,
    0x20U, 0x48U, 0x4DU, 0x41U, 0x43U, 0x20U, 0x28U, 0x6BU,
    0x65U, 0x79U, 0x65U, 0x64U, 0x2DU, 0x68U, 0x61U, 0x73U,
    0x68U, 0x20U, 0x6DU, 0x65U, 0x73U, 0x73U, 0x61U, 0x67U,
    0x65U, 0x20U, 0x61U, 0x75U, 0x74U, 0x68U, 0x65U, 0x6EU,
    0x74U, 0x69U, 0x63U, 0x61U, 0x74U, 0x69U, 0x6FU, 0x6EU,
    0x20U, 0x63U, 0x6FU, 0x64U, 0x65U, 0x29U, 0x20U, 0x61U,
    0x6CU, 0x67U, 0x6FU, 0x72U, 0x69U, 0x74U, 0x68U, 0x6DU,
    0x20U, 0x73U, 0x75U, 0x69U, 0x74U, 0x61U, 0x62U, 0x6CU,
    0x65U, 0x20U, 0x66U, 0x6FU, 0x72U, 0x20U, 0x61U, 0x20U,
    0x76U, 0x61U, 0x72U, 0x69U, 0x65U, 0x74U, 0x79U, 0x20U,
    0x6FU, 0x66U, 0x20U, 0x61U, 0x70U, 0x70U, 0x6CU, 0x69U,
    0x63U, 0x61U, 0x74U, 0x69U, 0x6FU, 0x6EU, 0x73U, 0x2EU,
    0x2AU, 0x2AU, 0x2AU, 0x20U, 0x53U, 0x54U, 0x4DU, 0x33U,
    0x32U, 0x20U, 0x2AU, 0x2AU, 0x2AU
};

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern HASH_HandleTypeDef hhash;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    uint8_t i;

    /* Device configuration */
    DAL_DeviceConfig();

    /* Compute SHA1 */
    if (DAL_HASH_SHA1_Start(&hhash, (uint8_t*)inputTable, HASH_INPUT_TABLE_SIZE, sha1Output, 0xFFU) != DAL_OK)
    {
        Error_Handler();
    }

    /* Digest print */
    LOGI(tag, "HASH SHA1 Degest\r\n");
    for (i = 0U; i < 20U; i++)
    {
        if (i % 4U == 0U)
        {
            LOG_Print("H%d = ", i / 4U);
        }

        LOG_Print("0x%02X  ", sha1Output[i]);

        if ((i + 1U) % 4U == 0U)
        {
            LOG_Print("\r\n");
        }
    }

    /* Infinite loop */
    while (1)
    {
        BOARD_LED_Toggle(LED2);
        DAL_Delay(500U);
    }
}
