/**
 * @file        apm32f4xx_qspi_cfg.c
 *
 * @brief       This file provides configuration support for QSPI
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_qspi_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
QSPI_HandleTypeDef hqspi;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initializes the QSPI MSP
 * 
 * @param  hqspi: QSPI handle
 * 
 * @retval None
 */
void DAL_QSPI_MspInit(QSPI_HandleTypeDef *hqspi)
{
    GPIO_InitTypeDef GPIO_InitStruct = {0U};

    if (hqspi->Instance == QSPI)
    {
        /* Enable GPIO clock */
        __DAL_RCM_GPIOB_CLK_ENABLE();
        __DAL_RCM_GPIOC_CLK_ENABLE();
        __DAL_RCM_GPIOE_CLK_ENABLE();

        /* Enable peripheral clock */
        __DAL_RCM_QSPI_CLK_ENABLE();

        /* QSPI GPIO Configuration */
        GPIO_InitStruct.Pin       = QSPI_IO0_PIN;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull      = GPIO_NOPULL;
        GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_VERY_HIGH;
        GPIO_InitStruct.Alternate = QSPI_IO0_AF;
        DAL_GPIO_Init(QSPI_IO0_GPIO_PORT, &GPIO_InitStruct);

        GPIO_InitStruct.Pin       = QSPI_IO1_PIN;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull      = GPIO_NOPULL;
        GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_VERY_HIGH;
        GPIO_InitStruct.Alternate = QSPI_IO1_AF;
        DAL_GPIO_Init(QSPI_IO1_GPIO_PORT, &GPIO_InitStruct);

        GPIO_InitStruct.Pin       = QSPI_IO2_PIN;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull      = GPIO_NOPULL;
        GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_VERY_HIGH;
        GPIO_InitStruct.Alternate = QSPI_IO2_AF;
        DAL_GPIO_Init(QSPI_IO2_GPIO_PORT, &GPIO_InitStruct);

        GPIO_InitStruct.Pin       = QSPI_IO3_PIN;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull      = GPIO_NOPULL;
        GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_VERY_HIGH;
        GPIO_InitStruct.Alternate = QSPI_IO3_AF;
        DAL_GPIO_Init(QSPI_IO3_GPIO_PORT, &GPIO_InitStruct);

        GPIO_InitStruct.Pin       = QSPI_CLK_PIN;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull      = GPIO_NOPULL;
        GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_VERY_HIGH;
        GPIO_InitStruct.Alternate = QSPI_CLK_AF;
        DAL_GPIO_Init(QSPI_CLK_GPIO_PORT, &GPIO_InitStruct);

        GPIO_InitStruct.Pin       = QSPI_CS_PIN;
        GPIO_InitStruct.Mode      = GPIO_MODE_OUTPUT_PP;
        GPIO_InitStruct.Pull      = GPIO_NOPULL;
        GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_VERY_HIGH;
        DAL_GPIO_Init(QSPI_CS_GPIO_PORT, &GPIO_InitStruct);

        /* Disable QSPI CS */
        DAL_GPIO_WritePin(QSPI_CS_GPIO_PORT, QSPI_CS_PIN, GPIO_PIN_SET);
    }
}

/**
 * @brief  DeInitializes the QSPI MSP
 * 
 * @param  hqspi: QSPI handle
 * 
 * @retval None
 */
void DAL_QSPI_MspDeInit(QSPI_HandleTypeDef *hqspi)
{
    if (hqspi->Instance == QSPI)
    {
        /* Disable peripheral clock */
        __DAL_RCM_QSPI_FORCE_RESET();
        __DAL_RCM_QSPI_RELEASE_RESET();

        /* QSPI GPIO Configuration */
        DAL_GPIO_DeInit(QSPI_IO0_GPIO_PORT, QSPI_IO0_PIN);
        DAL_GPIO_DeInit(QSPI_IO1_GPIO_PORT, QSPI_IO1_PIN);
        DAL_GPIO_DeInit(QSPI_IO2_GPIO_PORT, QSPI_IO2_PIN);
        DAL_GPIO_DeInit(QSPI_IO3_GPIO_PORT, QSPI_IO3_PIN);
        DAL_GPIO_DeInit(QSPI_CLK_GPIO_PORT, QSPI_CLK_PIN);
        DAL_GPIO_DeInit(QSPI_CS_GPIO_PORT, QSPI_CS_PIN);
    }
}

/**
 * @brief   QSPI configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_QSPI_Config(void)
{
    hqspi.Instance                  = QSPI;
    hqspi.Init.ClockPrescaler       = 12U;
    hqspi.Init.ClockPhase           = QSPI_CLOCK_PHASE_1ST_EDGE;
    hqspi.Init.ClockPolarity        = QSPI_CLOCK_POLARITY_LOW;
    hqspi.Init.ClockStretch         = ENABLE;
    hqspi.Init.TxFifoThreshold      = 0U;
    hqspi.Init.TxFifoLevel          = 0U;
    hqspi.Init.RxFifoThreshold      = 1U;
    hqspi.Init.ChipSelectToggle     = QSPI_CS_TOGGLE_DISABLE;
    if (DAL_QSPI_Init(&hqspi) != DAL_OK)
    {
        Error_Handler();
    }
}
