/**
 * @file        apm32f4xx_qspi_cfg.h
 *
 * @brief       This file provides configuration support for QSPI
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef APM32F4XX_QSPI_CFG_H
#define APM32F4XX_QSPI_CFG_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes ***************************************************************/
#include "apm32f4xx_dal.h"

/* Exported macro *********************************************************/
#define QSPI_IO0_GPIO_PORT              GPIOE
#define QSPI_IO0_PIN                    GPIO_PIN_7
#define QSPI_IO0_AF                     GPIO_AF10_QSPI

#define QSPI_IO1_GPIO_PORT              GPIOE
#define QSPI_IO1_PIN                    GPIO_PIN_8
#define QSPI_IO1_AF                     GPIO_AF10_QSPI

#define QSPI_IO2_GPIO_PORT              GPIOE
#define QSPI_IO2_PIN                    GPIO_PIN_9
#define QSPI_IO2_AF                     GPIO_AF10_QSPI

#define QSPI_IO3_GPIO_PORT              GPIOC
#define QSPI_IO3_PIN                    GPIO_PIN_5
#define QSPI_IO3_AF                     GPIO_AF10_QSPI

#define QSPI_CLK_GPIO_PORT              GPIOB
#define QSPI_CLK_PIN                    GPIO_PIN_1
#define QSPI_CLK_AF                     GPIO_AF9_QSPI

#define QSPI_CS_GPIO_PORT               GPIOB
#define QSPI_CS_PIN                     GPIO_PIN_6
#define QSPI_CS_AF                      GPIO_AF10_QSPI

/* Exported typedef *******************************************************/

/* Exported function prototypes *******************************************/
void DAL_QSPI_Config(void);

#ifdef __cplusplus
}
#endif

#endif /* APM32F4XX_QSPI_CFG_H */
