/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include "log.h"

#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "list.h"

/* Private macro **********************************************************/

/* Private variables ******************************************************/
static const char* tag = "main";

/* Private typedef ********************************************************/

/* Task handle */
static TaskHandle_t xHandleTaskLedToggle = NULL;
static TaskHandle_t xHandleTaskUsartTest = NULL;

/* Private function prototypes ********************************************/
static void UserTaskCreate(void);

/* Led toggle task */
void vTaskLedToggle(void *pvParameters);
/* Usart1 test task */
void vTaskUsartTest(void *pvParameters);

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    /* User create task */
    UserTaskCreate();

    /* Startup FreeRTOS */
    vTaskStartScheduler();
    
    /* Infinite loop */
    while (1);
}

/**
 * @brief   User Create Task
 *
 * @param   None
 *
 * @retval  None
 */
static void UserTaskCreate(void)
{
    xTaskCreate(vTaskLedToggle,
                "TaskLedToggle",
                 128U,
                 NULL,
                 0U,
                 &xHandleTaskLedToggle);

    xTaskCreate(vTaskUsartTest,
                "TaskUsartTest",
                128U,
                NULL,
                2U,
                &xHandleTaskUsartTest);
}

/**
 * @brief   Led toggle task
 *
 * @param   pvParameters - passed into the task function as the function parameters
 *
 * @retval  None
 */
void vTaskLedToggle(void *pvParameters)
{
    while (1)
    {
        /* Toggle LED2 */
        BOARD_LED_Toggle(LED2);
        /* Task blocking time Delay */
        vTaskDelay(500U);
    }
}

/**
 * @brief   USART test task
 *
 * @param   pvParameters - passed into the task function as the function parameters
 *
 * @retval  None
 */
void vTaskUsartTest(void *pvParameters)
{
    while (1)
    {
        LOGI(tag, "FreeRTOS\r\n");
        vTaskDelay(500U);
    }
}
