/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/
extern TMR_HandleTypeDef htmr8;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    uint32_t buffer[3] = {800U, 400U, 200U};

    /* Device configuration */
    DAL_DeviceConfig();

    /* Start channel 1 */
    if (DAL_TMR_PWM_Start_DMA(&htmr8, TMR_CHANNEL_1, buffer, 3U) != DAL_OK)
    {
        Error_Handler();
    }

    /* Wait till the channel 1 start process finish */
    while(htmr8.State != DAL_TMR_STATE_READY) 
    {
        
    }

    /* Set TMR DMA state to ready */
    htmr8.hdma[TMR_DMA_ID_CC1]->State = DAL_DMA_STATE_READY;

    /* Unlock TMR DMA to start channel 1N */
    __DAL_UNLOCK(htmr8.hdma[TMR_DMA_ID_CC1]);
    
    /* Disable TMR DMA to configure */
    __DAL_DMA_DISABLE(htmr8.hdma[TMR_DMA_ID_CC1]);
    
    /* Start channel 1N */
    if (DAL_TMREx_PWMN_Start_DMA(&htmr8, TMR_CHANNEL_1, buffer, 3U) != DAL_OK)
    {
        Error_Handler();
    }

    /* Infinite loop */
    while (1)
    {
        
    }
}
