/**
 * @file        apm32f4xx_dma_cfg.c
 *
 * @brief       This file provides configuration support for DMA
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_dma_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
DMA_HandleTypeDef hdma2;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   DMA configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_DMA_Config(void)
{
    __DAL_RCM_DMA2_CLK_ENABLE();

    /* DMA Init */
    hdma2.Instance = DMA2_Stream0;
    hdma2.Init.Channel              = DMA_CHANNEL_0;
    hdma2.Init.Direction            = DMA_MEMORY_TO_MEMORY;
    hdma2.Init.PeriphInc            = DMA_PINC_ENABLE;
    hdma2.Init.MemInc               = DMA_MINC_ENABLE;
    hdma2.Init.PeriphDataAlignment  = DMA_PDATAALIGN_WORD;
    hdma2.Init.MemDataAlignment     = DMA_MDATAALIGN_WORD;
    hdma2.Init.Mode                 = DMA_NORMAL;
    hdma2.Init.Priority             = DMA_PRIORITY_HIGH;
    hdma2.Init.FIFOMode             = DMA_FIFOMODE_ENABLE;
    hdma2.Init.FIFOThreshold        = DMA_FIFO_THRESHOLD_FULL;
    hdma2.Init.MemBurst             = DMA_MBURST_INC4;
    hdma2.Init.PeriphBurst          = DMA_PBURST_INC4;
    if (DAL_DMA_Init(&hdma2) != DAL_OK)
    {
        Error_Handler();
    }
}
