/**
 * @file        apm32f4xx_tmr_cfg.c
 *
 * @brief       This file provides configuration support for TMR
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_tmr_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
TMR_HandleTypeDef htmr1;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initializes the TMR PWM MSP
 *
 * @param  htmr TMR PWM handle
 *
 * @retval None
 */
void DAL_TMR_PWM_MspInit(TMR_HandleTypeDef *htmr)
{
    GPIO_InitTypeDef GPIO_InitStruct = {0};

    if (htmr->Instance == TMR1)
    {
        /* Enable peripheral clock */
        __DAL_RCM_TMR1_CLK_ENABLE();

        /* Enable peripheral GPIO clock */
        __DAL_RCM_GPIOE_CLK_ENABLE();

        /* TMR channel pin configuration */
        GPIO_InitStruct.Mode        = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull        = GPIO_PULLUP;
        GPIO_InitStruct.Speed       = GPIO_SPEED_HIGH;
        GPIO_InitStruct.Alternate   = GPIO_AF1_TMR1;

        /* TMR channel 1 and 1N */
        GPIO_InitStruct.Pin         = GPIO_PIN_8 | GPIO_PIN_9;
        DAL_GPIO_Init(GPIOE, &GPIO_InitStruct);
    }
}

/**
 * @brief  DeInitializes TMR PWM MSP
 *
 * @param  htmr TMR PWM handle
 *
 * @retval None
 */
void DAL_TMR_PWM_MspDeInit(TMR_HandleTypeDef *htmr)
{
    if (htmr->Instance == TMR1)
    {
        /* Enable peripheral clock */
        __DAL_RCM_TMR1_CLK_DISABLE();

        /* De-init peripheral GPIO */
        DAL_GPIO_DeInit(GPIOE, GPIO_PIN_8 | GPIO_PIN_9);
    }
}

/**
 * @brief   TMR1 configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_TMR1_Config(void)
{
    TMR_OC_InitTypeDef OC_ConfigStruct = {0};

    htmr1.Instance                  = TMR1;
    htmr1.Init.Prescaler            = 239U;
    htmr1.Init.CounterMode          = TMR_COUNTERMODE_UP;
    htmr1.Init.Period               = 999U;
    htmr1.Init.ClockDivision        = TMR_CLOCKDIVISION_DIV1;
    htmr1.Init.RepetitionCounter    = 0U;
    htmr1.Init.AutoReloadPreload    = TMR_AUTORELOAD_PRELOAD_DISABLE;
    if (DAL_TMR_PWM_Init(&htmr1) != DAL_OK)
    {
        Error_Handler();
    }

    /* Configure output channel 1 */
    OC_ConfigStruct.OCMode          = TMR_OCMODE_PWM1;
    OC_ConfigStruct.OCPolarity      = TMR_OCPOLARITY_HIGH;
    OC_ConfigStruct.OCNPolarity     = TMR_OCNPOLARITY_HIGH;
    OC_ConfigStruct.OCIdleState     = TMR_OCIDLESTATE_SET;
    OC_ConfigStruct.OCNIdleState    = TMR_OCNIDLESTATE_SET;
    OC_ConfigStruct.OCFastMode      = TMR_OCFAST_DISABLE;
    OC_ConfigStruct.Pulse           = 499U;
    if (DAL_TMR_PWM_ConfigChannel(&htmr1, &OC_ConfigStruct, TMR_CHANNEL_1) != DAL_OK)
    {
        Error_Handler();
    }
}
