/**
 * @file        apm32f4xx_tmr_cfg.c
 *
 * @brief       This file provides configuration support for TMR
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_tmr_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
TMR_HandleTypeDef htmr1;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief  Initializes the TMR Base MSP
 *
 * @param  htmr TMR Base handle
 *
 * @retval None
 */
void DAL_TMR_Base_MspInit(TMR_HandleTypeDef *htmr)
{
    if (htmr->Instance == TMR1)
    {
        /* Enable peripheral clock */
        __DAL_RCM_TMR1_CLK_ENABLE();
    }
}

/**
 * @brief  DeInitializes TMR Base MSP
 *
 * @param  htmr TMR Base handle
 *
 * @retval None
 */
void DAL_TMR_Base_MspDeInit(TMR_HandleTypeDef *htmr)
{
    if (htmr->Instance == TMR1)
    {
        /* Enable peripheral clock */
        __DAL_RCM_TMR1_CLK_DISABLE();

        /* Disable peripheral interrupt */
        DAL_NVIC_DisableIRQ(TMR1_UP_TMR10_IRQn);
    }
}

/**
 * @brief   TMR1 configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DAL_TMR1_Config(void)
{
    htmr1.Instance                  = TMR1;
    htmr1.Init.Prescaler            = 16799U;
    htmr1.Init.CounterMode          = TMR_COUNTERMODE_UP;
    htmr1.Init.Period               = 4999U;
    htmr1.Init.ClockDivision        = TMR_CLOCKDIVISION_DIV1;
    htmr1.Init.RepetitionCounter    = 0U;
    htmr1.Init.AutoReloadPreload    = TMR_AUTORELOAD_PRELOAD_DISABLE;
    if (DAL_TMR_Base_Init(&htmr1) != DAL_OK)
    {
        Error_Handler();
    }
}
