/**
 * @file        apm32f4xx_device_cfg.c
 *
 * @brief       This file provides all configuration support for device
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_device_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   Device configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DDL_DeviceConfig(void)
{
    /* Configure system clock */
    DDL_SysClkConfig();

    /* Configure peripheral clock */
    DDL_RCM_PeripheralClkConfig();

    /* Configure GPIO */
    DDL_GPIO_Config();

    /* Configure NVIC */
    DDL_NVIC_Config();
}

/**
 * @brief   Device reset
 *
 * @param   None
 *
 * @retval  None
 */
void DDL_DeviceReset(void)
{
    /* Reset Peripheral */

    /* Reset service */
}

/**
 * @brief   System clock configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DDL_SysClkConfig(void)
{
    /* Enable HSE */
    DDL_RCM_HSE_Enable();
    while(DDL_RCM_HSE_IsReady() != SET)
    {

    }

#if defined (APM32F425xx) || defined (APM32F427xx)
    /* Configure FLASH latency */
    DDL_FLASH_SetLatency(DDL_FLASH_LATENCY_7);

    /* Configure PLL */
    DDL_RCM_PLL_ConfigDomain_SYS(DDL_RCM_PLLSOURCE_HSE, DDL_RCM_PLLB_DIV_4, 240U, DDL_RCM_PLL1C_DIV_2);
#else
    /* Configure FLASH latency */
    DDL_FLASH_SetLatency(DDL_FLASH_LATENCY_6);

    DDL_RCM_PLL_ConfigDomain_SYS(DDL_RCM_PLLSOURCE_HSE, DDL_RCM_PLLB_DIV_4, 192U, DDL_RCM_PLL1C_DIV_2);
#endif /* APM32F425 || APM32F427 */
    DDL_RCM_PLL_Enable();
    while(DDL_RCM_PLL_IsReady() != SET)
    {

    }

    /* Configure Sysclk */
    DDL_RCM_SetAHBPrescaler(DDL_RCM_SYSCLK_DIV_1);
    DDL_RCM_SetSysClkSource(DDL_RCM_SYS_CLKSOURCE_PLL);
    while(DDL_RCM_GetSysClkSource() != DDL_RCM_SYS_CLKSOURCE_STATUS_PLL)
    {

    }

    /* Configure APB1 & APB2 prescaler */
    DDL_RCM_SetAPB1Prescaler(DDL_RCM_APB1_DIV_4);
    DDL_RCM_SetAPB2Prescaler(DDL_RCM_APB2_DIV_2);

    /* Update SystemCoreClock variable */
    SystemCoreClockUpdate();

    /* Set Systick to 1ms in using frequency set to SystemCoreClock */
    DDL_Init1msTick(SystemCoreClock);
}

#if defined(USE_FULL_ASSERT)
/**
 * @brief   Assert failed handler
 *
 * @param   file :Pointer to the source file name
 *
 * @param   line :Error line source number
 *
 * @retval  None
 */
void AssertFailedHandler(uint8_t *file, uint32_t line)
{
    /* When the function is needed, this function
       could be implemented in the user file
    */
    (void)(file);
    (void)(line);
    while(1)
    {
    }
}
#endif /* USE_FULL_ASSERT */
