/**
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "main.h"

/* Private includes *******************************************************/
#include "apm32f4xx_device_cfg.h"
#include <string.h>
#include <stdbool.h>
#include "log.h"

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/
uint8_t USART2ReceivedData = 0x00;
uint8_t USART2SendData = 0x00;

uint8_t USART3ReceivedData = 0x00;
uint8_t USART3SendData = 0xFF;

/* External variables *****************************************************/
extern UART_HandleTypeDef huart1;
extern IRDA_HandleTypeDef hirda2;
extern IRDA_HandleTypeDef hirda3;

/* External functions *****************************************************/

/**
 * @brief   Main program
 *
 * @param   None
 *
 * @retval  None
 */
int main(void)
{
    /* Device configuration */
    DAL_DeviceConfig();

    LOG_Print("This example provides a basic communication USARTx IrDA receive and transmit mode.\r\n");
    LOG_Print(">> SystemCoreClock: %lu\r\n", SystemCoreClock);

    /* Infinite loop */
    while (1)
    {
        DAL_Delay(500U);
        BOARD_LED_Toggle(LED2);

        DAL_IRDA_Transmit(&hirda2, &USART2SendData, 1, DAL_MAX_DELAY);
        DAL_IRDA_Receive(&hirda3, &USART3ReceivedData, 1, DAL_MAX_DELAY);
        LOG_Print("USART2 Send Data : 0x%02X ,USART3 Received Data : 0x%02X. \r\n", USART2SendData, USART3ReceivedData);

        DAL_IRDA_Transmit(&hirda3, &USART3SendData, 1, DAL_MAX_DELAY);
        DAL_IRDA_Receive(&hirda2, &USART2ReceivedData, 1, DAL_MAX_DELAY);
        LOG_Print("USART3 Send Data : 0x%02X ,USART2 Received Data : 0x%02X. \r\n", USART3SendData, USART2ReceivedData);

        USART2SendData++;
        USART3SendData--;
    }
}

/* Private functions ******************************************************/
