/**
 * @file        usbd_board.h
 *
 * @brief       Header file for USB Board
 *
 * @version     V1.0.0
 *
 * @date        2025-05-08
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Define to prevent recursive inclusion */
#ifndef USBD_BOARD_H
#define USBD_BOARD_H

#ifdef __cplusplus
  extern "C" {
#endif

/* Includes ***************************************************************/
#include "apm32f4xx_dal.h"

/* Exported macro *********************************************************/
#define USBD_FS_EP0_FIFO_SIZE                   0x40
#define USBD_FS_EP1_FIFO_SIZE                   0x40
#define USBD_FS_EP2_FIFO_SIZE                   0x40

#define USBD_MSC_IN_EP_ADDR                     0x81U
#define USBD_MSC_OUT_EP_ADDR                    0x01U

#define USBD_WINUSB_IN_EP_ADDR                  0x82U
#define USBD_WINUSB_OUT_EP_ADDR                 0x02U

#define USBD_MSC_INTERFACE_NUM                  0
#define USBD_MSC_INTERFACE_CNT                  1

#define USBD_MSC_FS_MP_SIZE                     0x40
#define USBD_MSC_HS_MP_SIZE                     0x200

#define USBD_SUP_MSC_MEDIA_PACKET               512

#define USBD_WINUSB_INTERFACE_NUM               1
#define USBD_WINUSB_INTERFACE_CNT               1
#define USBD_WINUSB_HS_INTERVAL                 0x10U
#define USBD_WINUSB_FS_INTERVAL                 0x10U
#define WINUSB_HS_MAX_PACKET_SIZE               512U
#define WINUSB_FS_MAX_PACKET_SIZE               64U

#define USBD_SUP_CLASS_MAX_NUM              1
#define USBD_SUP_INTERFACE_MAX_NUM          1
#define USBD_SUP_CONFIGURATION_MAX_NUM      1
#define USBD_SUP_STR_DESC_MAX_NUM           512

/* Only support LPM USB device */
#define USBD_SUP_LPM                        0U
#define USBD_SUP_SELF_PWR                   1U
#define USBD_DEBUG_LEVEL                    0U

#if (USBD_DEBUG_LEVEL > 0U)
#define USBD_USR_LOG(...)   do { \
                            printf(__VA_ARGS__); \
                            printf("\r\n"); \
} while(0)
#else
#define USBD_USR_LOG(...) do {} while (0)
#endif

#if (USBD_DEBUG_LEVEL > 1U)
#define USBD_USR_Debug(...)   do { \
                            printf("Debug:"); \
                            printf(__VA_ARGS__); \
                            printf("\r\n"); \
} while(0)
#else
#define USBD_USR_Debug(...) do {} while (0)
#endif

/* Exported typedef *******************************************************/

/* Exported function prototypes *******************************************/

#ifdef __cplusplus
}
#endif

#endif /* USBD_BOARD_H */
