/**
 * @file        apm32f4xx_gpio_cfg.c
 *
 * @brief       This file provides configuration support for GPIO
 *
 * @version     V1.0.0
 *
 * @date        2023-12-01
 *
 * @attention
 *
 *  Copyright (C) 2023 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "apm32f4xx_gpio_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/

/**
 * @brief   GPIO configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DDL_GPIO_Config(void)
{
    DDL_GPIO_SetPinMode(GPIOE, DDL_GPIO_PIN_5, DDL_GPIO_MODE_OUTPUT);

    DDL_GPIO_SetPinOutputType(GPIOE, DDL_GPIO_PIN_5, DDL_GPIO_OUTPUT_PUSHPULL);

    DDL_GPIO_SetPinSpeed(GPIOE, DDL_GPIO_PIN_5, DDL_GPIO_SPEED_FREQ_LOW);

    DDL_GPIO_SetPinPull(GPIOE, DDL_GPIO_PIN_5, DDL_GPIO_PULL_NO);
}
