/*!
 * @file        user_control.c
 *
 * @brief       Control USB switch role file
 *
 * @version     V1.0.0
 *
 * @date        2025-02-15
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "board.h"
#include "user_control.h"
#include "usb_device_user.h"
#include "usb_host_user.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

USB_STA_T usbstatus = USB_HOST;

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

extern USB_HOST_INFO_T hostInfo;

/* External functions *****************************************************/

/*!
 * @brief       USB Select
 *
 * @param       None
 *
 * @retval      None
 */
static void USB_Select(void)
{
    USB_STA_T pstatus = usbstatus;

    /* Press KEY3 to switch USB role */
    if (!BOARD_PBGetState(BUTTON_KEY3))
    {
        BOARD_DelayMs(10);
        if (!BOARD_PBGetState(BUTTON_KEY3))
        {
            /* Close HS IRQ */
            NVIC_DisableIRQRequest(OTG_HS1_IRQn);

            usbstatus = (USB_STA_T)((usbstatus + 1) % 2);
            BOARD_LEDToggle(LED1);
            BOARD_LEDToggle(LED2);
            while (!BOARD_PBGetState(BUTTON_KEY3));
        }
    }

    if(usbstatus != pstatus)
    {
        switch(usbstatus)
        {
            case USB_HOST:
                printf("Switch to HOST.\r\n");
                USB_DeviceReset();
                /* Clear USB HS Pending */
                __NVIC_ClearPendingIRQ(OTG_HS1_IRQn);

                USB_HostInitalize();
                break;
            case USB_DEVICE:
                printf("Switch to DEVICE.\r\n");
                USB_HostReset();
                /* Set USB Host state */
                hostInfo.state = USBH_APP_DISCONNECTION;

                /* Clear USB HS Pending */
                __NVIC_ClearPendingIRQ(OTG_HS1_IRQn);

                USB_DeviceInit();
                break;
            default:
                break;
        }
        NVIC_EnableIRQRequest(OTG_HS1_IRQn, 5, 0);
    }
}

/*!
 * @brief       USB Process
 *
 * @param       None
 *
 * @retval      None
 */
void USB_Process(void)
{
    if(usbstatus == USB_HOST)
    {
        USB_HostProcess();
    }
    USB_Select();
}

