/**
 * @file        g32m3101_adc_cfg.c
 *
 * @brief       This file provides configuration support for ADC
 *
 * @version     V1.0.0
 *
 * @date        2025-06-01
 *
 * @attention
 *
 *  Copyright (C) 2025 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be useful and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

/* Includes ***************************************************************/
#include "g32m3101_adc_cfg.h"

/* Private includes *******************************************************/

/* Private macro **********************************************************/

/* Private typedef ********************************************************/

/* Private variables ******************************************************/

/* Private function prototypes ********************************************/

/* External variables *****************************************************/

/* External functions *****************************************************/


/**
 * @brief   ADC1 configuration
 *
 * @param   None
 *
 * @retval  None
 */
void DDL_ADC1_Config(void)
{
    DDL_GPIO_InitTypeDef GPIO_InitStruct = {0U};
    
    DDL_SCU_Unlock();
    DDL_SCU_EnableAHBPeripheralClock(DDL_SCU_AHB_PERIPHERAL_GPIOA);
    DDL_SCU_EnableAPBPeripheralClock(DDL_SCU_APB_PERIPHERAL_ADC1);
    DDL_SCU_Lock();

    /* Configure the ADC1 pin */
    GPIO_InitStruct.Pin        = DDL_GPIO_PIN_1;
    GPIO_InitStruct.Mode       = DDL_GPIO_MODE_ANALOG;
    
    DDL_GPIO_LockKey(GPIOB, DDL_GPIO_LOCK_DISABLE);
    DDL_GPIO_Init(GPIOB, &GPIO_InitStruct);
    DDL_GPIO_LockKey(GPIOB, DDL_GPIO_LOCK_ENABLE);

    /* Set ADC Prescaler value */
    DDL_SCU_Unlock();
    DDL_SCU_SetADCClkDiv(DDL_SCU_ADCCLK_DIVISION_4);
    DDL_SCU_Lock();

    if(!DDL_ADC_IsConversionOngoing(ADC1))
    {
        DDL_ADC_REG_SetTriggerSource(ADC1, DDL_ADC_REG_TRIG_SOFTWARE);
    
        /* Set ADC data alignment */
        DDL_ADC_SetDataAlignment(ADC1, DDL_ADC_ALIGNMENT_RIGHT);
        
        /* Enable ADC continuous conversion mode */
        DDL_ADC_REG_SetContinuousMode(ADC1, DDL_ADC_REG_CONV_CONTINUOUS);
        DDL_ADC_REG_SetSequencerDiscont(ADC1, DDL_ADC_REG_SEQ_DISCONT_DISABLE);
        
        /* Enable ADC DMA continuous request */
        DDL_ADC_REG_SetDMATransfer(ADC1, DDL_ADC_REG_DMA_TRANSFER_CIRCULAR_MODE); 
        
        /* Set sampling time  */
        DDL_ADC_SetFastChannelSamplingTime(ADC1, DDL_ADC_SAMPLINGTIME_FAST_3CYCLES);
        
        /* Set ADC number of conversion, 1 */
        DDL_ADC_REG_SetSequencerLength(ADC1, DDL_ADC_REG_SEQ_SCAN_DISABLE);
        
        /* Configure for the selected ADC regular channel */
        DDL_ADC_REG_SetSequencerRanks(ADC1, DDL_ADC_REG_RANK_1, DDL_ADC_CHANNEL_4);
    }
}
